% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.mmsbm_fit}
\alias{.mmsbm_fit}
\title{Fitter Function for dynamic MMSBM Model}
\arguments{
\item{z_t}{Numeric matrix; transpose of monadic design matrix. Should not include intercept row.}

\item{x_t}{Numeric matrix; transpose of dyadic design matrix.}

\item{y}{Numeric vector; vector of edge values. Must have same number of elements as \code{ncol(x_t)}}

\item{time_id_dyad}{Integer vector; zero-based time-period identifier for each dyad.}

\item{time_id_dyad}{Integer vector; zero-based time-period identifier for each node.}

\item{nodes_per_period}{Integer vector; total number of unique nodes observed in each time period.}

\item{node_id_dyad}{Integer matrix; zero-based sender and receiver identifier per dyad.}

\item{mu_b}{Numeric matrix; matrix of prior means for elements in blockmodel matrix.}

\item{var_b}{Numeric matrix; matrix of prior variances for elements in blockmodel matrix.}

\item{phi_init}{Numeric matrix; matrix of initial mixed-memberships. Nodes along columns.}

\item{kappa_init_t}{Numeric matrix; matrix of initial marginal HMM state probabilities. Time-periods along columns.}

\item{b_init_t}{Numeric matrix; square matrix of initial values of blockmodel.}

\item{beta_init}{Numeric vector; flat array (column-major order) of initial values of monadic coefficients.}

\item{gamma_init}{Numeric vector; vector of initial values of dyadic coefficients}

\item{control}{List; see the \code{mmsbm.control} argument of \code{\link{mmsbm}}}
}
\value{
Unclassed list with named components; see \code{Value} of \code{\link{mmsbm}}
}
\description{
This is the interface to the C++ fitter for the dynamic mixed-membership
stochastic blockmodel for network regression.
}
\section{Warning}{

         This function is for internal use only. End-users should always resort to \code{\link{mmsbm}}.
         In particular, that interface post-processes the return value of this internal in important ways.
}

\author{
Kosuke Imai (imai@harvard.edu), Tyler Pratt (tyler.pratt@yale.edu), Santiago Olivella (olivella@unc.edu)
}
