% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-from_formula.R
\name{getFormula}
\alias{getFormula}
\title{Find possible formulas for a given m/z}
\usage{
getFormula(
  mz,
  add_name,
  adducts,
  ppm,
  elements = c("C", "H", "N", "O", "P", "S")
)
}
\arguments{
\item{mz}{M/z of interest}

\item{add_name}{Which adducts to consider}

\item{adducts}{Full adduct table (data(adducts) loads it into memory)}

\item{ppm}{Allowed error margin in parts per million}

\item{elements}{Considered elements in formula generation, Default: c("C", "H", "N", "O", "P", "S")}
}
\value{
Table with found formulas, their adduct and isotope percentage.
}
\description{
Using m/z and isotope distributions for each element, find possible molecular formulas within allowed error margin
}
\examples{
getFormula(170, "[M+H]1+", adducts, 3)
}
\seealso{
\code{\link[stringr]{str_match}}
 \code{\link[Rdisop]{initializeCHNOPS}}
}
