\name{parallelPlot}
\alias{parallelPlot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Create a parallel plot for a specified point on the frontier.
}
\description{
    \code{parallelPlot()} creates a parallel plot for a specified point
    on the frontier. Wraps \code{parcoord()} from \pkg{MASS}.
}
\usage{
parallelPlot(frontier.object, N, variables, treated.col = 'grey', control.col = 'black')
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{frontier.object}{
    An object generated by \code{makeFrontier().}
  }
  \item{N}{
    The number of observations left in the exported data set.
    If the user selects an undefined point, \code{generateDataset}
    returns a dataset from the nearest defined point on the
    frontier.
  }
  \item{variables}{
    The variables to be included in the parallel plot.
  }
  \item{treated.col}{
    The color of the lines corresponding to observations assigned to the
    treatment. Grey by default.
  }
  \item{control.col}{
    The color of the lines corresponding to observations assigned to the
    control. Black by default. 
  }
}
\references{
  Venables, William N., and Brian D. Ripley. Modern applied statistics with S. Springer, 2002.
}
\examples{
data(lalonde)

match.on <- colnames(lalonde)[!(colnames(lalonde) \%in\% c('re78', 'treat'))]
mahal.frontier <- makeFrontier(dataset = lalonde,
                            treatment = 'treat',
                            outcome = 're78',
                            match.on = match.on)
parallelPlot(mahal.frontier,
             N = 300,
             variables = c('age',
             're74',
             're75',
             'black'),
             treated.col = 'grey',
             control.col = 'blue'
             )
}
