% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetDist.R
\name{WQDSAdjustLengths}
\alias{WQDSAdjustLengths}
\title{Adjust edge lengths on tree built from Weighted Quartet distance 
to estimate metric tree}
\usage{
WQDSAdjustLengths(tree)
}
\arguments{
\item{tree}{an unrooted metric tree, of type phylo}
}
\value{
an unrooted metric tree, of type phylo
}
\description{
Modify edge lengths of a tree built from a distance table produced by \code{quartetWeightedDist},
to remove scaling factors related to the size of the split associated to the edge.
}
\details{
As explained by \insertCite{YR19;textual}{MSCquartets}, a metric tree produced from
the weighted quartet distance has edge lengths
inflated by a factor dependent on the associated split size. Removing these
factors 
yields a consistent estimate of the metric species tree displaying the weighted
quartets, if such a tree exists.

This function should not be used on trees output from \code{WQDS}, \code{WQDC},
or \code{WQDCrecursive}, as 
their edges are already adjusted. It can be used on trees built from the distance
computed by \code{quartetWeightedDist}.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
DQT=quartetTableDominant(RQT,bigweights="finite")
D=quartetWeightedDist(DQT)
tree=NJ(D)
write.tree(tree)
plot(tree)
stree=WQDSAdjustLengths(tree)
write.tree(stree)
plot(stree)

}
\references{
\insertRef{YR19}{MSCquartets}
}
\seealso{
\code{\link{WQDS}},
\code{\link{WQDC}}
}
