% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knapsackSampling.R
\name{sampl.mcmc}
\alias{sampl.mcmc}
\title{Generate feasible solutions to a knapsack problem using Markov Chain Monte Carlo}
\usage{
sampl.mcmc(init, numSampl, maxIter = 2 * numSampl, constraints = NULL)
}
\arguments{
\item{init}{- an initial feasible solution}

\item{numSampl}{- number of samples to be generated}

\item{maxIter}{- maximum number of iterations to be run to prevent infinite loop}

\item{constraints}{- a list of list of constraints with constr.mat, constr.dir, constr.rhs in each sublist
Please see example for an example of constraints.}
}
\value{
a matrix of {0, 1} with each row representing a sample
}
\description{
Generate feasible solutions to a knapsack problem using Markov Chain Monte Carlo
}
\examples{

#number of variables
N <- 100

#number of variables in each group
grpLen <- 10

#equality matrix
A <- matrix(c(rep(1, N)), ncol=N, byrow=TRUE)

#inequality matrix
G <- matrix(c(rep(1, grpLen), rep(0, N - grpLen),
    rep(c(0,1), each=grpLen), rep(0, N - 2*grpLen)), ncol=N, byrow=TRUE)

#construct a list of list of constraints
constraints <- list(
    list(constr.mat=A, constr.dir=rep("==", nrow(A)), constr.rhs=c(20)),
    list(constr.mat=G, constr.dir=rep("<=", nrow(G)), constr.rhs=c(5, 5)),
    list(constr.mat=G, constr.dir=rep(">=", nrow(G)), constr.rhs=c(1, 2))
)

#generate an initial feasible solution
init <- initState(N, constraints=constraints)

#create feasible solutions to knapsack problems subject to constraints
samples <- sampl.mcmc(init, 50, constraints=constraints)

}

