/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.ClassList;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.omegahat.Environment.Tools.ClassList.ClassList;

public class ArchiveClassList
extends ClassList
implements Serializable,
Externalizable {
    protected ZipFile zipFile;

    public ArchiveClassList() {
    }

    public ArchiveClassList(File file) {
        super(file);
    }

    public Object add(Object object) {
        if (object instanceof ZipEntry) {
            return this.add((ZipEntry)object);
        }
        return super.add(object);
    }

    public Object add(ZipEntry zipEntry) {
        return super.add(zipEntry);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.file((File)objectInput.readObject());
        int n = objectInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectInput.readObject();
            this.addElement(this.zipFile().getEntry(string));
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.file((File)objectInputStream.readObject());
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectInputStream.readObject();
            this.addElement(this.zipFile().getEntry(string));
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.file());
        int n = this.size();
        objectOutput.writeInt(n);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            objectOutput.writeObject(((ZipEntry)enumeration.nextElement()).getName());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.file());
        int n = this.size();
        objectOutputStream.writeInt(n);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            objectOutputStream.writeObject(((ZipEntry)enumeration.nextElement()).getName());
        }
    }

    public ZipFile zipFile() throws ZipException, IOException {
        if (this.zipFile == null) {
            this.zipFile(this.file());
        }
        return this.zipFile;
    }

    public ZipFile zipFile(File file) throws ZipException, IOException {
        return this.zipFile(new ZipFile(file));
    }

    public ZipFile zipFile(ZipFile zipFile) throws ZipException, IOException {
        this.zipFile = zipFile;
        return this.zipFile();
    }
}

