/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import antlr.collections.AST;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Parser.Parse.BasicExpression;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.MethodParameter;
import org.omegahat.Environment.Parser.Parse.StatementList;

public class Catch
extends BasicExpression
implements ExpressionInt {
    protected MethodParameter thrownClass = null;
    protected StatementList body = null;
    protected boolean isFinal = false;

    public Catch(MethodParameter methodParameter, StatementList statementList) {
        this.thrownClass(methodParameter);
        this.body(statementList);
    }

    public Catch(StatementList statementList, boolean bl) {
        this.body(statementList);
        this.setParent(this.body);
        this.isFinal = bl;
    }

    public Class Class(Evaluator evaluator) throws ClassNotFoundException {
        Class clazz = this.thrownClass.Class(evaluator);
        return clazz;
    }

    public StatementList body() {
        return this.body;
    }

    public StatementList body(StatementList statementList) {
        this.body = statementList;
        this.setParent(this.body);
        if (this.body() != null && this.body() instanceof AST && this.thrownClass() != null && this.thrownClass() instanceof AST) {
            this.thrownClass().setNextSibling((AST)this.body());
        }
        return this.body();
    }

    public Object eval(Throwable throwable, Evaluator evaluator) throws Throwable {
        if (this.body == null) {
            return null;
        }
        Object object = null;
        Database database = null;
        try {
            database = this.evaluationFrame("Catch Work Area", evaluator);
            evaluator.attach(database, 0);
            database.assign(this.thrownClass().name(), throwable);
            this.body.handleLocalFrame(false);
            object = this.eval(evaluator);
        }
        finally {
            Object var6_5 = null;
            if (database != null) {
                evaluator.detach(database);
            }
        }
        return object;
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        Object object = this.body.eval(evaluator);
        return object;
    }

    public AST getFirstChild() {
        return this.thrownClass();
    }

    public MethodParameter thrownClass() {
        return this.thrownClass;
    }

    public MethodParameter thrownClass(MethodParameter methodParameter) {
        this.thrownClass = methodParameter;
        this.setParent(this.thrownClass);
        return this.thrownClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.isFinal) {
            stringBuffer.append("finally ");
        } else {
            stringBuffer.append(" catch(" + this.thrownClass + ")");
        }
        stringBuffer.append("{" + (this.body != null && this.body.size() > 0 ? "\n" + this.body.asString(false, "\t") + ";\n" : "") + "}\n");
        return stringBuffer.toString();
    }
}

