/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.IO;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import org.omegahat.Environment.IO.ObjectDisplayFilter;
import org.omegahat.Environment.IO.SelfDisplaying;
import org.omegahat.Environment.Parser.Parse.List;

public class BasicObjectDisplay
implements ObjectDisplayFilter {
    public static String OutputElementSeparator = "\n";
    protected PrintWriter stdout;

    public BasicObjectDisplay() {
        this(new PrintWriter(System.out));
    }

    public BasicObjectDisplay(PrintWriter printWriter) {
        this.stdout(printWriter);
    }

    public boolean defaultDisplay(Object object) {
        return this.defaultDisplay(object, 0L);
    }

    public boolean defaultDisplay(Object object, long l) {
        this.stdout().print(object);
        return true;
    }

    public boolean display(Object object) {
        boolean bl = this.display(object, 0L);
        this.stdout().print("\n");
        this.stdout().flush();
        return bl;
    }

    public boolean display(Object object, long l) {
        if (object != null) {
            if (object instanceof SelfDisplaying) {
                ((SelfDisplaying)object).display(this, l);
            }
            if (object.getClass().isArray()) {
                this.displayArray(object);
            } else if (object instanceof Enumeration) {
                this.display((Enumeration)object);
            } else if (object instanceof List) {
                this.stdout().print(((List)object).toString(false));
            } else {
                this.defaultDisplay(object, l);
            }
        } else {
            this.defaultDisplay("null");
        }
        return true;
    }

    public boolean display(Enumeration enumeration) {
        this.display(String.valueOf(String.valueOf(enumeration.getClass())) + " enumeration ");
        return true;
    }

    public boolean displayArray(Object object) {
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            this.stdout().print(String.valueOf(String.valueOf(Array.get(object, n2))) + (n2 < n - 1 ? OutputElementSeparator : ""));
            ++n2;
        }
        return true;
    }

    public PrintWriter stdout() {
        return this.stdout;
    }

    public PrintWriter stdout(PrintWriter printWriter) {
        this.stdout = printWriter;
        return this.stdout();
    }

    public String toString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public Writer toWriter(Object object) {
        this.stdout().println(this.toString(object));
        return this.stdout();
    }

    public Writer writer() {
        return this.stdout();
    }
}

