/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUITools.MethodViewer;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.omegahat.Environment.GUITools.MethodViewer.MethodTreeModel;

public class MethodTreeRenderer
implements TreeCellRenderer {
    public String asString(Class clazz) {
        if (clazz.isArray()) {
            return String.valueOf(this.asString(clazz.getComponentType())) + "[]";
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    public String asString(Object object) {
        String string = object instanceof Integer ? MethodTreeModel.TypeNames[(Integer)object] : (object instanceof Method ? this.asString((Method)object) : (object instanceof Constructor ? this.asString((Constructor)object) : (object instanceof Field ? this.asString((Field)object) : (object instanceof Class ? this.asString((Class)object) : object.toString()))));
        return string;
    }

    public String asString(String string, Class clazz, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (clazz != null) {
            stringBuffer.append(this.asString(clazz));
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        stringBuffer.append(" (");
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.asString(classArray[n2]));
            if (n2 < n - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String asString(Constructor constructor) {
        return this.asString(this.asString(constructor.getDeclaringClass()), null, constructor.getParameterTypes());
    }

    public String asString(Field field) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asString(field.getType()));
        stringBuffer.append(" ");
        stringBuffer.append(field.getName());
        return stringBuffer.toString();
    }

    public String asString(Method method) {
        return this.asString(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public Color color(Object object) {
        Color color = Color.black;
        if (!(object instanceof String)) {
            if (object instanceof Method) {
                color = Color.blue;
            } else if (object instanceof Constructor) {
                color = Color.green;
            } else if (object instanceof Field) {
                color = Color.red;
            }
        }
        return color;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = this.asString(object);
        if (n == 0 && ((Class)object).isInterface()) {
            string = String.valueOf(string) + " (interface)";
        }
        if (string == null) {
            string = "Unhandled object " + object.getClass() + " (" + object + ")";
        }
        JLabel jLabel = new JLabel(string);
        Color color = this.color(object);
        if (color != null) {
            jLabel.setForeground(color);
        }
        Icon icon = null;
        icon = this.icon(object);
        if (icon != null) {
            jLabel.setIcon(icon);
        }
        return jLabel;
    }

    public Icon icon(Object object) {
        int n = -1;
        if (object instanceof Method) {
            n = ((Method)object).getModifiers();
        } else if (object instanceof Constructor) {
            n = ((Constructor)object).getModifiers();
        } else if (object instanceof Field) {
            n = ((Field)object).getModifiers();
        }
        if (n < 0) {
            return null;
        }
        ImageIcon imageIcon = null;
        String string = null;
        if (Modifier.isPrivate(n)) {
            string = "private.gif";
        } else if (Modifier.isProtected(n)) {
            string = "protected.gif";
        } else if (Modifier.isPublic(n)) {
            string = "public.gif";
        }
        if (string != null) {
            URL uRL = this.getClass().getResource(string);
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }
}

