/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Databases;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omegahat.Environment.DataStructures.Subsettable;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.DatabaseAssignEvent;
import org.omegahat.Environment.Databases.DatabaseAssignListener;
import org.omegahat.Environment.Databases.DatabaseAttachListener;
import org.omegahat.Environment.Databases.DatabaseCustomer;
import org.omegahat.Environment.Databases.DatabaseDetachListener;
import org.omegahat.Environment.Databases.DatabaseEvent;
import org.omegahat.Environment.Databases.DatabaseNotifier;
import org.omegahat.Environment.Databases.DatabaseRemoveEvent;
import org.omegahat.Environment.Databases.DatabaseRemoveListener;
import org.omegahat.Environment.Databases.MergableInt;
import org.omegahat.Environment.Databases.ObjectNotFoundException;
import org.omegahat.Environment.Interpreter.DynamicFieldAccessInt;
import org.omegahat.Environment.Parser.Parse.List;
import org.omegahat.Environment.Utils.Named;

public class ObjectDatabase
implements Database,
MergableInt,
DatabaseNotifier,
Named,
Serializable,
DynamicFieldAccessInt,
Subsettable {
    protected Hashtable table;
    protected String name = null;
    protected Vector[] listeners = new Vector[4];
    protected int state = 1;
    protected int permissions = 1;
    protected Vector user = null;

    public ObjectDatabase() {
        this(10);
    }

    public ObjectDatabase(int n) {
        this.table(new Hashtable(n));
    }

    public ObjectDatabase(String string) {
        this(10);
        this.name = string;
    }

    public ObjectDatabase(String string, int n) {
        this(n);
        this.name = string;
    }

    public ObjectDatabase(Hashtable hashtable) {
        this(hashtable != null ? hashtable.size() : 10);
        this.merge(hashtable, true);
    }

    public ObjectDatabase(Hashtable hashtable, String string) {
        this(hashtable);
        this.setName(string);
    }

    public boolean addAssignListener(DatabaseAssignListener databaseAssignListener) {
        return this.addListener(2, databaseAssignListener);
    }

    public boolean addAttachListener(DatabaseAttachListener databaseAttachListener) {
        return this.addListener(1, databaseAttachListener);
    }

    public boolean addDetachListener(DatabaseDetachListener databaseDetachListener) {
        return this.addListener(0, databaseDetachListener);
    }

    public boolean addListener(int n, Object object) {
        if ((n < 0 || n > this.listeners.length - 1) && n != -1) {
            return false;
        }
        if (n == -1) {
            int n2 = 0;
            while (n2 < this.listeners.length) {
                this.addListener(n2, object);
                ++n2;
            }
        } else {
            if (this.listeners[n] == null) {
                this.listeners[n] = new Vector(1);
            }
            this.listeners[n].addElement(object);
        }
        return true;
    }

    public boolean addRemoveListener(DatabaseRemoveListener databaseRemoveListener) {
        return this.addListener(3, databaseRemoveListener);
    }

    public boolean assign(String string, Object object) throws Exception {
        return this.assign(string, object, true);
    }

    public boolean assign(String string, Object object, boolean bl) throws Exception {
        if (this.readOnly()) {
            throw new Exception("Database is read-only");
        }
        if (object == null) {
            object = Database.NULL_ENTRY;
        }
        this.put(string, object);
        if (bl) {
            this.notify(new DatabaseAssignEvent(string, this), 2);
        }
        return true;
    }

    public boolean attach(DatabaseCustomer databaseCustomer) {
        return true;
    }

    public void clear() {
        this.table().clear();
    }

    public boolean detach(DatabaseCustomer databaseCustomer) {
        return true;
    }

    public boolean exists(String string) {
        return this.table().containsKey(string);
    }

    public Object get(String string) {
        if (this.getState() == 0) {
            return null;
        }
        Object v = this.table().get(string);
        if (v == Database.NULL_ENTRY) {
            return null;
        }
        return v;
    }

    public Object getDynamicField(String string) throws Throwable {
        if (this.exists(string)) {
            return this.get(string);
        }
        throw new ObjectNotFoundException(string);
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.state;
    }

    public Hashtable getTable() {
        return this.table;
    }

    public int merge(Hashtable hashtable, boolean bl) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (!bl && this.exists(string)) continue;
            try {
                this.assign(string, hashtable.get(string));
            }
            catch (Exception exception) {}
        }
        return this.size();
    }

    public int merge(Database database, boolean bl) {
        String[] stringArray = database.objects();
        int n = 0;
        while (n < stringArray.length) {
            if (bl || !this.exists(stringArray[n])) {
                try {
                    this.assign(stringArray[n], database.get(stringArray[n]));
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return this.size();
    }

    public void notify(DatabaseEvent databaseEvent, int n) {
        if (this.listeners == null || n < 0 || n >= this.listeners.length || this.listeners[n] == null) {
            return;
        }
        Enumeration enumeration = this.listeners[n].elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            switch (n) {
                case 2: {
                    ((DatabaseAssignListener)e).assignPerformed((DatabaseAssignEvent)databaseEvent);
                    break;
                }
                case 3: {
                    ((DatabaseRemoveListener)e).removePerformed((DatabaseRemoveEvent)databaseEvent);
                    break;
                }
            }
        }
    }

    public String[] objects() {
        String[] stringArray = new String[this.size()];
        int n = 0;
        Enumeration enumeration = this.table().keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            object2 = Database.NULL_ENTRY;
        }
        return this.table().put(object, object2);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        System.err.println("Read object " + this.getClass());
        try {
            objectInputStream.defaultReadObject();
            System.err.println("Done");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Failed");
            return;
        }
    }

    public boolean readOnly() {
        return (this.getState() & 2) != 0;
    }

    public boolean readOnly(boolean bl) {
        this.state &= 2;
        return this.readOnly();
    }

    public static ObjectDatabase readSerialized(File file) throws FileNotFoundException, StreamCorruptedException, ClassNotFoundException, OptionalDataException, IOException {
        return ObjectDatabase.readSerialized(new FileInputStream(file));
    }

    public static ObjectDatabase readSerialized(InputStream inputStream) throws StreamCorruptedException, ClassNotFoundException, OptionalDataException, IOException {
        return (ObjectDatabase)new ObjectInputStream(inputStream).readObject();
    }

    public static ObjectDatabase readSerialized(String string) throws FileNotFoundException, StreamCorruptedException, ClassNotFoundException, OptionalDataException, IOException {
        return ObjectDatabase.readSerialized(new File(string));
    }

    public Object remove(String string) {
        return this.remove(string, true);
    }

    public Object remove(String string, boolean bl) {
        Object var3_3 = null;
        if (this.table().containsKey(string)) {
            var3_3 = this.table().remove(string);
            if (bl) {
                this.notify(new DatabaseRemoveEvent(string, this), 3);
            }
        }
        return var3_3;
    }

    public Object setDynamicField(String string, Object object) throws Throwable {
        this.assign(string, object);
        return object;
    }

    public String setName(String string) {
        this.name = string;
        return this.getName();
    }

    public int setState(int n) {
        this.state = n;
        return this.getState();
    }

    public Hashtable setTable(Hashtable hashtable) {
        this.table = hashtable;
        return this.table;
    }

    public int size() {
        return this.table().size();
    }

    public Object subset(Object object, boolean bl) throws Throwable {
        ObjectDatabase objectDatabase = null;
        Object object2 = null;
        if (bl) {
            objectDatabase = (ObjectDatabase)this.getClass().newInstance();
            object2 = objectDatabase;
        }
        if (object instanceof List) {
            if (((List)object).size() > 1) {
                object2 = new List(3);
            }
            Enumeration enumeration = ((List)object).elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Object object3 = this.subset(e, false);
                if (bl) {
                    objectDatabase.put(e.toString(), object3);
                    continue;
                }
                if (object2 instanceof List) {
                    ((List)object2).addElement(object3);
                    continue;
                }
                object2 = object3;
            }
        } else if (object instanceof String) {
            Object object4 = this.get((String)object);
            if (bl) {
                objectDatabase.assign((String)object, object4);
            } else {
                object2 = object4;
            }
        } else {
            throw new Exception("Don't understand indeces of type " + object.getClass());
        }
        return object2;
    }

    public Hashtable table() {
        return this.table;
    }

    public Hashtable table(Hashtable hashtable) {
        this.table = hashtable;
        return this.table();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        System.err.println("Writing object " + this.getClass());
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

