% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.create.snp.names.R
\name{f.create.snp.names}
\alias{f.create.snp.names}
\title{Intern function for creating column names for genotype data}
\usage{
f.create.snp.names(map.file, ncol, format, design)
}
\arguments{
\item{map.file}{Filename (with path if the file is not in current directory) of the
.map file holding the SNP names, if available (see Details).}

\item{ncol}{Number of columns IN TOTAL in the dataset containing only the genotype data}

\item{format}{Format of data (will influence how data is processed) - choose from:
\itemize{
  \item \emph{haplin} - data already in one row per family,
  \item \emph{ped} - data from .ped file, each row represents an individual.
}.}

\item{design}{The design used in the study - choose from:
\itemize{
  \item \emph{triad} - (default), data includes genotypes of mother, father and child;
  \item \emph{cc} - classical case-control;
  \item \emph{cc.triad} - hybrid design: triads with cases and controls
}.}
}
\value{
A list containing:
  \itemize{
    \item \emph{gen.data.colnames} - a vector with names of columns, length equal to 
      the number of columns in the genotype dataset (i.e., depending on the format and
      design).
    \item \emph{marker.names} - a vector containing the names of markers, as read in
      from 'map.file', or dummy names.
  }
}
\description{
Creating column names either from a .map file or generating dummy names
}
\details{
If the .map file is given, the SNP names are read in, if not dummy names are
 created by attaching numbers to "m" prefix. Then, a "_a" and "_b" suffix is
 attached to each allele, respectively. Finally, if the design is "triad" or
 "cc.triad", the following suffixes are attached: "_m" for the mother's
 alleles, "_f" for the father's, and "_c" for the child's.
}
\section{Details}{

The .map file should contain at least two columns, where the second one contains SNP 
  names. Any additional columns should be separated by a whitespace character, but will 
  be ignored. The file should contain a header.
}

