% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary.R
\name{plot_summary}
\alias{plot_summary}
\title{Summary of the clusters}
\usage{
plot_summary(
  output_clusters,
  data,
  type = "multi",
  type_summ = "param",
  nb_digits = 3,
  html = TRUE,
  variable_names = NULL
)
}
\arguments{
\item{output_clusters}{list. List of the sites in the clusters: it is the sites_clusters of the output of NPFSS, PFSS, DFFSS, URBFSS, MDFFSS, MRBFSS, MG, MNP, UG or UNP, or the sites_clusters_LH/sites_clusters_W/sites_clusters_P/sites_clusters_R of the MPFSS.}

\item{data}{list of numeric matrices or a matrix, or a vector. List of nb_sites (or nb_individuals if the observations are by individuals and not by site) matrices of the data, the rows correspond to the variables and each column represents an observation time (multivariate case) ; or Matrix of the data, the rows correspond to the sites (or to the individuals) and each column represents an observation time (univariate case). The times must be the same for each site/individual and they may need to be equally spaced depending on the scan method ; Or vector a the data (univariate non-functional framework) in which each element corresponds to a site or an individual.}

\item{type}{character. Type of the data: "multi" (for multivariate data) or "funct" (for functional univariate data or functional multivariate data). Only taken into account when the data is a matrix : if the data is a vector (univariate context) the value has no importance.}

\item{type_summ}{character. "param" or "nparam". "param" gives the mean and the sd for each variable in the clusters, outside, and globally and "nparam" gives the Q25, Q50 and Q75 quantiles for each variables in the clusters, outside, and globally.}

\item{nb_digits}{integer. Number of decimals in the means, sds and quantiles.}

\item{html}{logical. If TRUE the table is an HTML table. This allows a better readability but a less good extraction of the information than if html = FALSE: in the latter case the table is simply returned in the console.}

\item{variable_names}{character vector. The names of the variables if you want the names to appear. By default NULL: the names are var1, var2, etc. Only considered for multivariate functional or multivariate non-functional data.}
}
\value{
No value returned, displays the results in the console (html = FALSE) or in the Viewer (html = TRUE)
}
\description{
This function gives a summary of the clusters in a table
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- NPFSS(data = funi_data, sites_coord = coords, system = "WGS84",
mini = 1, maxi = nrow(coords)/2)

plot_summary(output_clusters = res_npfss$sites_clusters, data = funi_data,
type = "funct", type_summ = "param")
plot_summary(output_clusters = res_npfss$sites_clusters, data = funi_data,
type = "funct", type_summ = "nparam")}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- which(map_sites$NAME_3 == "Lille")
coords <- coordinates(map_sites[indices,])
res_npfss <- NPFSS(data = funi_data[indices,], sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)
if(length(res_npfss$sites_clusters)>0){
plot_summary(output_clusters = res_npfss$sites_clusters,
data = funi_data[indices,],
type = "funct", type_summ = "param", html = FALSE)
}

}


}
