% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_map2}
\alias{plot_map2}
\title{Map of the clusters}
\usage{
plot_map2(spobject, sites_coord, output_clusters, system, colors = "red")
}
\arguments{
\item{spobject}{SpObject. SpatialObject corresponding the sites.}

\item{sites_coord}{numeric matrix. Coordinates of the sites or the individuals, in the same order that the data for the cluster detection.}

\item{output_clusters}{list. List of the sites in the clusters: it is the sites_clusters of the output of NPFSS, PFSS, DFFSS, URBFSS, MDFFSS, MRBFSS, MG, MNP, UG or UNP, or the sites_clusters_LH/sites_clusters_W/sites_clusters_P/sites_clusters_R of the MPFSS.}

\item{system}{character. System in which the coordinates are expressed: "Euclidean" or "WGS84".}

\item{colors}{character. Colors of the clusters. If length(colors)=1 all the clusters will be in this color. Else it should be a vector of length the number of clusters to plot.}
}
\value{
No value returned, plots a map of the sites and the clusters.
}
\description{
This function plots a map of the sites and the clusters
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- NPFSS(data = funi_data, sites_coord = coords, system = "WGS84",
mini = 1, maxi = nrow(coords)/2)

plot_map2(spobject = map_sites, sites_coord = coords,
output_clusters = res_npfss$sites_clusters, system = "WGS84")}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- which(map_sites$NAME_3 == "Lille")
coords <- coordinates(map_sites[indices,])
res_npfss <- NPFSS(data = funi_data[indices,], sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)
if(length(res_npfss$sites_clusters)>0){
plot_map2(spobject = map_sites[indices,], sites_coord = coords,
output_clusters = res_npfss$sites_clusters, system = "WGS84")
}

}

}
