##' Multivariate and Functional Spatial Scan Statistics
##'
##' Allows to detect spatial clusters of abnormal values on multivariate or functional data.
##'
##' \tabular{ll}{
##' Package: \tab HDSpatialScan\cr
##' Type: \tab Package\cr
##' Version: \tab 1.0.0\cr
##' Date: \tab 2021-05-20\cr
##' License: \tab GPL-3\cr
##' LazyLoad: \tab yes\cr
##' }
##'
##' @name HDSpatialScan-package
##' @aliases HDSpatialScan
##' @rdname HDSpatialScan-package
##' @docType package
##' @keywords package
##' @import Rcpp
##' @import parallel
##' @import purrr
##' @import matrixStats
##' @import SpatialNP
##' @import sp
##' @import DT
##' @import TeachingDemos
##' @import plotrix
##' @import fmsb
##' @import rgdal
##' @import swfscMisc
##' @importFrom rgeos gUnaryUnion
##' @importFrom graphics legend lines par points
##' @importFrom stats quantile sd
##' @importFrom grDevices adjustcolor
##'
##' @useDynLib HDSpatialScan
##'
##' @author FREVENT Camille, AHMED Mohamed-Salem, SOULA Julien, SMIDA Zaineb, CUCALA Lionel, DABO-NIANG Sophie and GENIN Michaël. Maintainer: FREVENT Camille <camille.frevent@univ-lille.fr>
##'
##'
##' @references Martin Kulldorff and Lan Huang and Kevin Konty (2009). A Scan Statistic for Continuous Data Based on the Normal Probability Model. International Journal of Health Geographics, 8 (58).
##'
##' Inkyung Jung and Ho Jin Cho (2015). A Nonparametric Spatial Scan Statistic for Continuous Data. International Journal of Health Geographics, 14.
##'
##' Lionel Cucala and Michaël Genin and Caroline Lanier and Florent Occelli (2017). A Multivariate Gaussian Scan Statistic for Spatial Data. Spatial Statistics, 21, 66-74.
##'
##' Lionel Cucala and Michaël Genin and Florent Occelli and Julien Soula (2019). A Multivariate Nonparametric Scan Statistic for Spatial Data. Spatial statistics, 29, 1-14.
##'
##' Zaineb Smida and Lionel Cucala and Ali Gannoun. A Nonparametric Spatial Scan Statistic for Functional Data. Pre-print.
##'
##' Camille Frévent and Mohamed-Salem Ahmed and Matthieu Marbac and Michaël Genin. Detecting Spatial Clusters in Functional Data: New Scan Statistic Approaches. Pre-print.
##'
##' Camille Frévent and Mohamed-Salem Ahmed and Sophie Dabo-Niang and Michaël Genin. Investigating Spatial Scan Statistics for Multivariate Functional Data. Pre-print.
##'
##'
##'
NULL
