% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comb_SA.R
\name{comb_SA}
\alias{comb_SA}
\title{Simple Average Forecast Combination}
\usage{
comb_SA(x)
}
\arguments{
\item{x}{An object of class \code{foreccomb}. Contains training set (actual values + matrix of model forecasts) and optionally a test set.}
}
\value{
Returns an object of class \code{foreccomb_res} with the following components:
\item{Method}{Returns the used forecast combination method.}
\item{Models}{Returns the individual input models that were used for the forecast combinations.}
\item{Weights}{Returns the combination weights obtained by applying the combination method to the training set.}
\item{Fitted}{Returns the fitted values of the combination method for the training set.}
\item{Accuracy_Train}{Returns range of summary measures of the forecast accuracy for the training set.}
\item{Forecasts_Test}{Returns forecasts produced by the combination method for the test set. Only returned if input included a forecast matrix for the test set.}
\item{Accuracy_Test}{Returns range of summary measures of the forecast accuracy for the test set. Only returned if input included a forecast matrix and a vector of actual values for the test set.}
\item{Input_Data}{Returns the data forwarded to the method.}
}
\description{
Computes forecast combination weights using simple average and produces forecasts for the test set, if provided.
}
\details{
Suppose \eqn{y_t} is the variable of interest, there are \eqn{N} not perfectly collinear predictors,
\eqn{\mathbf{f}_t = (f_{1t}, \ldots, f_{Nt})'}{f_t = (f_{1t}, \ldots, f_{Nt})'}. The simple average gives equal weights to all predictors:

\deqn{\mathbf{w}^{SA} = \frac{1}{N}}{w = 1/N}

The combined forecast is then obtained by:

\deqn{\hat{y}_t = {\mathbf{f}_{t}}'\mathbf{w}^{SA}}{\hat{y}_t = (f_t)'w}

It is well-documented that simple average is a robust combination method that is hard to beat (e.g., Stock and Watson, 2004; Timmermann, 2006).
This is often associated with the importance of parameter estimation error in sophisticated techniques -- a problem that simple averaging avoids.
However, simple averaging may not be a suitable combination method when some of the predictors are biased (Palm and Zellner, 1992).
}
\examples{
obs <- rnorm(100)
preds <- matrix(rnorm(1000, 1), 100, 10)
train_o<-obs[1:80]
train_p<-preds[1:80,]
test_o<-obs[81:100]
test_p<-preds[81:100,]

data<-foreccomb(train_o, train_p, test_o, test_p)
comb_SA(data)

}
\author{
Christoph E. Weiss and Gernot R. Roetzer
}
\references{
Palm, F. C., and Zellner, A. (1992). To Combine or not to Combine? Issues of Combining Forecasts. \emph{Journal of Forecasting}, \bold{11(8)}, 687--701.

Stock, J. H., and Watson, M. W. (2004). Combination Forecasts of Output Growth in a Seven-Country Data Set. \emph{Journal of Forecasting}, \bold{23(6)},
405--430.

Timmermann, A. (2006). Forecast Combinations. In: Elliott, G., Granger, C. W. J., and Timmermann, A. (Eds.), \emph{Handbook of Economic Forecasting},
\bold{1}, 135--196.
}
\seealso{
\code{\link{foreccomb}},
\code{\link{plot.foreccomb_res}},
\code{\link{summary.foreccomb_res}},
\code{\link{accuracy}}
}
\keyword{models}

