% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFCtabulate.R
\name{INFCtabulate}
\alias{INFCtabulate}
\title{Reproduce the tables that Tabacchi et al. published in 2011}
\usage{
INFCtabulate(
  EPPOcode,
  quantity = "vol",
  dbh.by = 5,
  htot.by = 3,
  digits = 1,
  print_tab = T
)
}
\arguments{
\item{EPPOcode}{tree species code defined by the
EPPO database \url{https://gd.eppo.int/search}.
Lookup 'INFCspecies' dataframe to retrieve recognized codes.}

\item{quantity}{for each species (or species group) different
quantities can be estimated. Quantity's definitions and Ids are exposed by
the 'Quantities' dataframe. Default value is "vol", estimation of timber volume.}

\item{dbh.by}{...}

\item{htot.by}{increment value between rows
(respectively columns) expressed in 'cm' (respectively 'm') for \code{dbh}
(respectively total height, \code{htot}). Default 5 cm (respectively 1 m).}

\item{digits}{number of decimal digits to expose in the table.
Default one decimal digit.}

\item{print_tab}{defaults to TRUE in order to produce a text output. If set
to FALSE no printing will occur (see 'return')}
}
\value{
Function principal output is the printout of the volume or phytomass tables.
If print_tab = FALSE, the function will only return a tibble with a list column
containing the tabulation of the required estimation equation/s.
Using default values, tables will be identical (or anyway similar) to the
corresponding published tables, with white (NA) cells delimiting the domain of
applicability of the equation.
}
\description{
The tables published in the work on which this package is based, convey a very
relevant part of the information produced: printed numbers serve as reference to
verify that coded functions return expected results and, more specifically, empty
spaces in the printed tables signal function applicability domain. In other words,
measurement data used to estimate function coefficients values, cover only the
portion of the \code{(dbh, htot)} plane where numbers are printed.
}
\examples{
\dontrun{
  INFCtabulate(c("ABIAL", "ACRCA"),
                quantity = "vol",
                dbh.by = 5,
                htot.by = 3,
                digits = 1)
  # EPPO code:  ABIAL  - pag =  33  - quantity =  vol
  #     htot.m
  # dbh.cm    7    10    13    16     19     22     25     28     31
  # 9  23.2  32.4    NA    NA     NA     NA     NA     NA     NA
  # 14   NA  77.9 100.2    NA     NA     NA     NA     NA     NA
  # 19   NA 142.3 183.3 224.3     NA     NA     NA     NA     NA
  # 24   NA    NA 291.1 356.4  421.8  487.2     NA     NA     NA
  # 29   NA    NA    NA 518.9  614.3  709.8  805.2     NA     NA
  # 34   NA    NA    NA 711.6  842.8  974.0 1105.2 1236.4     NA
  # 39   NA    NA    NA    NA 1107.2 1279.8 1452.5 1625.1 1797.7
  # 44   NA    NA    NA    NA     NA 1627.2 1847.0 2066.7 2286.5
  # 49   NA    NA    NA    NA     NA 2016.3 2288.8 2561.4 2833.9
  # 54   NA    NA    NA    NA     NA     NA 2778.0 3109.0 3439.9
  # 59   NA    NA    NA    NA     NA     NA 3314.4 3709.5 4104.6
  # 64   NA    NA    NA    NA     NA     NA     NA 4363.1 4828.0
  
  
  # ---
  #   EPPO code:  ACRCA  - pag =  231  - quantity =  vol
  # htot.m
  # dbh.cm  7.5  10.5  13.5  16.5   19.5   22.5
  # 9.5  26.8  36.8    NA    NA     NA     NA
  # 14.5   NA  83.6 106.9    NA     NA     NA
  # 19.5   NA 149.7 192.0 234.3  276.6     NA
  # 24.5   NA    NA 302.2 369.0  435.7     NA
  # 29.5   NA    NA    NA 534.2  631.0  727.8
  # 34.5   NA    NA    NA 729.9  862.4  994.8
  # 39.5   NA    NA    NA    NA 1129.9 1303.5
  # ---
  }

}
