% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Uniform}
\alias{Uniform}
\alias{dUniform}
\alias{eUniform}
\alias{lUniform}
\alias{pUniform}
\alias{qUniform}
\alias{rUniform}
\title{The Uniform Distribution.}
\usage{
dUniform(x, a = 2, b = 3, params = list(a, b))

pUniform(q, a = 2, b = 3, params = list(a, b))

qUniform(p, a = 2, b = 3, params = list(a, b))

rUniform(n, a = 2, b = 3, params = list(a, b))

eUniform(X, w, method = "numerical.MLE")

lUniform(X, w, a = 2, b = 3, params = list(a, b), logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{a,b}{boundary parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lUniform gives log likelihood.}

\item{...}{other parameters}
}
\value{
dUniform gives the density; pUniform gives the distribution function;
qUniform gives the quantile function; rUniform generates random variables;
eUniform estimate the parameters; sUniform gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Uniform distribution
}
\details{
Uniform Distribution -----------------------------------------------------

See \href{../doc/Distributions-Uniform.html}{Distributions-Uniform}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
a <- 1
b <- 2
X <- rUniform(n, a, b)
(est.par <- eUniform(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dUniform(den.x,a=est.par$a,b=est.par$b)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qUniform((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot", xlab="Theoretical Quantiles",
ylab="Sample Quantiles", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

plot((1:n-0.5)/n, pUniform(sort(X), params=est.par), main="P-P Plot", xlab="Theoretical Percentile",
ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(a=1, b=2)
X <- rUniform(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eUniform(X,w) # estimated parameters of weighted sample
eUniform(X) # estimated parameters of unweighted sample

# Alternative parameter estimation methods
(est.par <- eUniform(X, method = "numerical.MLE"))

# Extracting boundary parameters
est.par[attributes(est.par)$par.type=="boundary"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rUniform,edist=eUniform,n = 1000, rep.num = 1e3,
params = list(a=2, b=5), method ="numerical.MLE")
eval.estimation(rdist=rUniform,edist=eUniform,n = 1000, rep.num = 1e3,
params = list(a=2, b=5), method ="MOM")

# evaluate the precision of estimation by Hessian matrix
X <- rUniform(1000, a, b)
(est.par <- eUniform(X))
H <- attributes(eUniform(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lUniform(X,param = est.par)
lUniform(X,param = est.par, logL=FALSE)
sUniform(X,param = est.par)
iUniform(X,param = est.par)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

