% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Normal}
\alias{Normal}
\alias{dNormal}
\alias{eNormal}
\alias{iNormal}
\alias{lNormal}
\alias{pNormal}
\alias{qNormal}
\alias{rNormal}
\alias{sNormal}
\title{The Normal Distribution.}
\usage{
dNormal(x, mean = 0, sd = 1, params = list(mean, sd))

pNormal(q, mean = 0, sd = 1, params = list(mean, sd))

qNormal(p, mean = 0, sd = 1, params = list(mean, sd))

rNormal(n, mean = 0, sd = 1, params = list(mean, sd))

eNormal(X, w, method = "numerical.MLE")

lNormal(X, w, mean = 0, sd = 1, params = list(mean, sd), logL = TRUE)

sNormal(X, w, mean = 0, sd = 1, params = list(mean, sd))

iNormal(X, w, mean = 0, sd = 1, params = list(mean, sd))
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{mean}{location parameter.}

\item{sd}{scale parameter.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lNormal gives log likelihood.}

\item{...}{other parameters}
}
\value{
dNormal gives the density; pNormal gives the distribution function;
qNormal gives the quantile function; rNormal generates random variables;
eNormal estimate the parameters; sNormal gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Normal distribution
}
\details{
Normal Distribution

See \href{../doc/Distributions-Normal.html}{Distributions-Normal}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
mean <- 1
sd <- 2
X <- rNormal(n, mean, sd)
(est.par <- eNormal(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dNormal(den.x,mean=est.par$mean,sd=est.par$sd)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qNormal((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(-5,5), ylim = c(-5,5))
abline(0,1)

plot((1:n-0.5)/n, pNormal(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(mean=1, sd=2)
X <- rNormal(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eNormal(X,w) # estimated parameters of weighted sample
eNormal(X) # estimated parameters of unweighted sample

# Alternative parameter estimation methods
eNormal(X, method = "numerical.MLE")
eNormal(X, method = "bias.adjusted.MLE")
mean(X); sd(X); sd(X)*sqrt((n-1)/n)

# Extracting location or scale parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rNormal,edist=eNormal,n = 1000, rep.num = 1e3, params = list(mean=1, sd=2))
eval.estimation(rdist=rNormal,edist=eNormal,n = 1000, rep.num = 1e3, params = list(mean=1, sd=2),
method ="analytical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rNormal(1000, mean, sd)
(est.par <- eNormal(X))
H <- attributes(eNormal(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lNormal(X,param = est.par)
lNormal(X,param = est.par, logL=FALSE)
sNormal(X,param = est.par)
iNormal(X,param = est.par)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

