% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Gamma}
\alias{Gamma}
\alias{dGamma}
\alias{eGamma}
\alias{lGamma}
\alias{pGamma}
\alias{qGamma}
\alias{rGamma}
\title{The Gamma Distribution.}
\usage{
dGamma(x, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

pGamma(q, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

qGamma(p, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

rGamma(n, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

eGamma(X, w, method = "numerical.MLE")

lGamma(X, w, shape = 2, scale = 2, params = list(shape = 2, scale = 2),
  logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{shape}{shape parameter.}

\item{scale}{scale parameter.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lGamma gives log likelihood.}

\item{...}{other parameters}
}
\value{
dGamma gives the density; pGamma gives the distribution function;
qGamma gives the quantile function; rGamma generates random variables;
eGamma estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Gamma distribution
}
\details{
Gamma Distribution

See \href{../doc/Distributions-Gamma.html}{Distributions-Gamma}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
shape <- 1.5
scale <- 0.5
X <- rGamma(n, shape, scale)
(est.par <- eGamma(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dGamma(den.x,shape=est.par$shape,scale=est.par$scale)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qGamma((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(0,5), ylim = c(0,5))
abline(0,1)

plot((1:n-0.5)/n, pGamma(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape=1, scale=2)
X <- rGamma(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eGamma(X,w) # estimated parameters of weighted sample
eGamma(X) # estimated parameters of unweighted sample

# Extracting shape or scale parameters
est.par[attributes(est.par)$par.type=="shape"]
est.par[attributes(est.par)$par.type=="scale"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rGamma,edist=eGamma,n = 1000, rep.num = 1e3, params = list(shape=1, scale=2))

# evaluate the precision of estimation by Hessian matrix
X <- rGamma(1000, shape, scale)
(est.par <- eGamma(X))
H <- attributes(eGamma(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lGamma(X,param = est.par)
lGamma(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

