% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_scatter_plot.R
\name{prepare_scatter_plot}
\alias{prepare_scatter_plot}
\title{Prepares a Scatter Plot}
\usage{
prepare_scatter_plot(df, x, y, color = "", size = "", loess = 0,
  alpha = min(1, 1/((1 + (max(0, log(nrow(df)) - log(100)))))))
}
\arguments{
\item{df}{Data frame containing the data}

\item{x}{a string containing the column name of the x variable}

\item{y}{a string containing the column name of the y variable}

\item{color}{a string containing the column name of the variable providing the color aesthetic
(can be numerical or a factor)}

\item{size}{a string containing the column name of the variable providing the size aesthetic}

\item{loess}{a numerical scalar
\describe{
 \item{0}{No loess curve}
 \item{1}{loess curve with equal weights}
 \item{2}{loess curve with weights based on \code{size} variable}
}}

\item{alpha}{The alpha value to be used.
If missing, it calculates a default based on the sample size}
}
\value{
the plot as returned by \code{ggplot}
}
\description{
Reads a data frame and prepares a scatter plot.
}
\examples{
df <- data.frame(year = floor(stats::time(datasets::EuStockMarkets)),
                 datasets::EuStockMarkets[, c("DAX", "FTSE")])
prepare_scatter_plot(df, x="DAX", y="FTSE", color="year")
}
