% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover_designer.R
\name{spillover_designer}
\alias{spillover_designer}
\alias{simple_spillover_designer}
\title{Create a design with spillovers}
\usage{
spillover_designer(N_groups = 80, N_i_group = 3, sd_i = 0.2,
  gamma = 2, args_to_fix = NULL)
}
\arguments{
\item{N_groups}{An integer. Number of groups.}

\item{N_i_group}{Number of units in each group. Can be scalar or vector of length \code{N_groups}.}

\item{sd_i}{A nonnegative number. Standard deviation of individual-level shock.}

\item{gamma}{A number. Parameter that controls whether spillovers within groups substitute or complement each other. See `Details`.}

\item{args_to_fix}{A character vector. Names of arguments to be args_to_fix in design.}
}
\value{
A simple spillover design.
}
\description{
Builds a design with \code{N_groups} groups each containing \code{N_i_group} individuals. 
Potential outcomes exhibit spillovers: if any individual in a group receives treatment, 
the effect is spread equally among members of the group.
}
\details{
Parameter \code{gamma} controls interactions between spillover effects.For \code{gamma}=1 for every $1 given to a member of a group, each member receives $1*\code{N_i_group} no matter how many others are already treated.
For \code{gamma}>1 (<1) for every $1 given to a member of a group, each member receives an amount that depends negatively (positively) on the number already treated.  

The default estimand is the average difference across subjects between no one treated and only that subject treated.
}
\examples{
# Generate a simple spillover design using default arguments:
spillover_design <- spillover_designer()

}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{experiment}
\concept{spillovers}
