% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_helper_functions.R,
%   R/design_print_summary.R
\name{post_design}
\alias{post_design}
\alias{print_code}
\alias{print.design}
\alias{summary.design}
\title{Explore your design}
\usage{
print_code(design)

\method{print}{design}(x, verbose = TRUE, ...)

\method{summary}{design}(object, verbose = TRUE, ...)
}
\arguments{
\item{design}{A design object, typically created using the + operator}

\item{x}{a design object, typically created using the + operator}

\item{verbose}{an indicator for printing a long summary of the design, defaults to \code{TRUE}}

\item{...}{optional arguments to be sent to summary function}

\item{object}{a design object created using the + operator}
}
\description{
Explore your design

Print code to recreate a design
}
\examples{

design <-
  declare_model(
    N = 500, 
    U = rnorm(N),
    potential_outcomes(Y ~ U + Z * rnorm(N, 2, 2))
  ) +
  declare_sampling(S = complete_rs(N, n = 250), legacy = FALSE) +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_assignment(Z = complete_ra(N, m = 25), legacy = FALSE) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) +
  declare_estimator(Y ~ Z, inquiry = "my_inquiry")

design

df <- draw_data(design)

estimates <- draw_estimates(design)
inquiries <- draw_inquiries(design)

print_code(design)


my_population <- declare_model(N = 100)

my_assignment <- declare_assignment(Z = complete_ra(N, m = 50), legacy = FALSE)

my_design <- my_population + my_assignment

print_code(my_design)


my_model <- 
  declare_model(
    N = 500, 
    noise = rnorm(N),
    Y_Z_0 = noise, 
    Y_Z_1 = noise + rnorm(N, mean = 2, sd = 2)
  )

my_sampling <- declare_sampling(S = complete_rs(N, n = 250), legacy = FALSE)

my_assignment <- declare_assignment(Z = complete_ra(N, m = 25), legacy = FALSE)

my_inquiry <- declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0))

my_estimator <- declare_estimator(Y ~ Z, inquiry = my_inquiry)

my_reveal <- declare_measurement(Y = reveal_outcomes(Y ~ Z))

design <- my_model +
  my_sampling +
  my_inquiry +
  my_assignment +
  my_reveal +
  my_estimator

summary(design)
}
