% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbSendQuery,DatabaseConnectorDbiConnection,character-method}
\alias{dbSendQuery,DatabaseConnectorDbiConnection,character-method}
\title{Execute a query on a given database connection}
\usage{
\S4method{dbSendQuery}{DatabaseConnectorDbiConnection,character}(conn,
  statement, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbSendQuery()} returns
an S4 object that inherits from \linkS4class{DBIResult}.
The result set can be used with \code{\link[=dbFetch]{dbFetch()}} to extract records.
Once you have finished using a result, make sure to clear it
with \code{\link[=dbClearResult]{dbClearResult()}}.
An error is raised when issuing a query over a closed
or invalid connection,
if the syntax of the query is invalid,
or if the query is not a non-\code{NA} string.
}
\description{
The \code{dbSendQuery()} method only submits and synchronously executes the
SQL query to the database engine.  It does \emph{not} extract any
records --- for that you need to use the \code{\link[=dbFetch]{dbFetch()}} method, and
then you must call \code{\link[=dbClearResult]{dbClearResult()}} when you finish fetching the
records you need. For interactive use, you should almost always prefer
\code{\link[=dbGetQuery]{dbGetQuery()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbSendQuery")}
}
\details{
This method is for \code{SELECT} queries only.  Some backends may
support data manipulation queries through this method for compatibility
reasons.  However, callers are strongly encouraged to use
\code{\link[=dbSendStatement]{dbSendStatement()}} for data manipulation statements.

The query is submitted to the database server and the DBMS executes it,
possibly generating vast amounts of data. Where these data live
is driver-specific: some drivers may choose to leave the output on the server
and transfer them piecemeal to R, others may transfer all the data to the
client -- but not necessarily to the memory that R manages. See individual
drivers' \code{dbSendQuery()} documentation for details.
}
\seealso{
For updates: \code{\link[=dbSendStatement]{dbSendStatement()}} and \code{\link[=dbExecute]{dbExecute()}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbAppendTable}}, \code{\link{dbCreateTable}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbListFields}},
  \code{\link{dbListObjects}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
