% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBconsensus.R
\name{BBconsensus}
\alias{BBconsensus}
\title{Find the first approximation to the consensus ranking. Most of the time the output is a solution, maybe not unique}
\usage{
BBconsensus(RR, cij, FULL = FALSE, PS = FALSE)
}
\arguments{
\item{RR}{Candidate to be the consensus ranking}

\item{cij}{Combined input matrix of the data set}

\item{FULL}{Default FULL=FALSE. If FULL=TRUE, the searching is limited to the space of complete rankings. FULL=TRUE if the function is called by BBFULL algorithm.}

\item{PS}{Default PS=FALSE. If PS=TRUE the number of evaluated branches is diplayed}
}
\value{
a "list" containing the following components:
\tabular{lll}{
cons \tab  \tab a first approximation of the median ranking\cr
pen \tab       \tab penalty value}
}
\description{
Find a first approximation to the consensus ranking.
}
\references{
Amodio, S., D'Ambrosio, A. and Siciliano, R. (2016). Accurate algorithms for identifying the median ranking when dealing with weak and partial rankings under the Kemeny axiomatic approach. European Journal of Operational Research, 249(2), 667-676.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
