% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCodeUse.R
\name{tableCohortCodeUse}
\alias{tableCohortCodeUse}
\title{Format the result of summariseCohortCodeUse into a table.}
\usage{
tableCohortCodeUse(
  result,
  type = "gt",
  header = c("cdm_name", "estimate_name"),
  groupColumns = NULL,
  timing = FALSE,
  hide = character(),
  .options = list()
)
}
\arguments{
\item{result}{A summarised result with results of the type "cohort_code_use".}

\item{type}{Type of desired formatted table. To see supported formats
use visOmopResults::tableType()}

\item{header}{A vector specifying the elements to include in the header. The
order of elements matters, with the first being the topmost header.
The header vector can contain one of the following variables: "cdm_name",
"codelist_name", "standard_concept_name", "standard_concept_id",
"estimate_name", "source_concept_name", "source_concept_id", "domain_id". If
results are stratified, "year", "sex", "age_group" can also be used.
Alternatively, it can include other names to use as overall header labels.}

\item{groupColumns}{Variables to use as group labels. Allowed columns are:
"cdm_name", "codelist_name", "standard_concept_name", "standard_concept_id",
"estimate_name", "source_concept_name", "source_concept_id", "domain_id". If
results are stratified, "year", "sex", "age_group" can also be used.
These cannot be used in header.}

\item{timing}{If TRUE the timing setting will be displayed.}

\item{hide}{Table columns to exclude, options are: "cdm_name",
"codelist_name", "year", "sex", "age_group", "standard_concept_name",
"standard_concept_id", "estimate_name", "source_concept_name",
"source_concept_id", "domain_id". If results are stratified, "year", "sex",
"age_group" can also be used. These cannot be used in header or groupColumn.}

\item{.options}{Named list with additional formatting options.
visOmopResults::tableOptions() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseCohortCodeUse
result.
}
\description{
Format the result of summariseCohortCodeUse into a table.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(),
                      dbdir = CDMConnector::eunomia_dir())
cdm <- CDMConnector::cdm_from_con(con,
                                  cdm_schem = "main",
                                  write_schema = "main")
cdm <- CDMConnector::generateConceptCohortSet(cdm = cdm,
conceptSet = list(a = 260139,
                  b = 1127433),
                  name = "cohorts",
                  end = "observation_period_end_date",
                  overwrite = TRUE)

results_cohort_mult <-
summariseCohortCodeUse(list(cs = c(260139,19133873)),
                      cdm = cdm,
                      cohortTable = "cohorts",
                      timing = "entry")

tableCohortCodeUse(results_cohort_mult)
CDMConnector::cdmDisconnect(cdm)
}

}
