% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugCodes.R
\name{getDrugIngredientCodes}
\alias{getDrugIngredientCodes}
\title{Get descendant codes for drug ingredients}
\usage{
getDrugIngredientCodes(cdm, name = NULL, doseForm = NULL)
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{name}{Names of ingredients of interest. For example, c("acetaminophen",
"codeine"), would result in a list of length two with the descendant
concepts for these two particular drug ingredients.}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}
}
\value{
A named list, with each item containing descendant concepts of
an ingredient
}
\description{
Get descendant codes for drug ingredients
}
\examples{
cdm <- mockVocabRef()
getDrugIngredientCodes(cdm = cdm, name = "Adalimumab")
DBI::dbDisconnect(attr(cdm, "dbcon"), shutdown = TRUE)
}
