% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusbootemm.R
\name{summary.clusbootemm}
\alias{summary.clusbootemm}
\title{Summarize estimated marginal means for cluster bootstrap GLM into a grid}
\usage{
\method{summary}{clusbootemm}(object, ...)
}
\arguments{
\item{object}{object of class \code{clusbootemm}.}

\item{...}{other arguments.}
}
\description{
Returns the summary of the EMM for a \code{clusbootglm} class object.
}
\examples{
\dontrun{
medication <- medication[medication$time \%\% 1 == 0,]
medication$time_f <- as.factor(medication$time)
set.seed(1)
model.1 <- clusbootglm(pos~time_f*treat, clusterid=id, data=medication)
emm.1 <- emm(object = model.1)
summary(object = emm.1)}
}
\author{
Mathijs Deen
}
