% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioM2.R
\name{Stage1_FeartureSelection}
\alias{Stage1_FeartureSelection}
\title{Stage 1 Fearture Selection}
\usage{
Stage1_FeartureSelection(
  Stage1_FeartureSelection_Method = "cor",
  data = NULL,
  cutoff = NULL,
  featureAnno = NULL,
  pathlistDB_sub = NULL,
  MinfeatureNum_pathways = 10,
  cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{Stage1_FeartureSelection_Method}{Feature selection methods. Available options are
c(NULL, 'cor', 'wilcox.test', 'cor_rank', 'wilcox.test_rank').}

\item{data}{The input training dataset. The first column is the label.}

\item{cutoff}{The cutoff used for feature selection threshold. It can be any value
between 0 and 1. Commonly used cutoffs are c(0.5, 0.1, 0.05, 0.01, etc.).}

\item{featureAnno}{The annotation data stored in a data.frame for probe
mapping. It must have at least two columns named 'ID' and 'entrezID'.
(For details, please refer to data( data("MethylAnno") )}

\item{pathlistDB_sub}{A list of pathways with pathway IDs and their
corresponding genes ('entrezID' is used).
For details, please refer to ( data("GO2ALLEGS_BP") )}

\item{MinfeatureNum_pathways}{The minimal defined pathway size after mapping your
own data to pathlistDB(KEGG database/GO database).}

\item{cores}{The number of cores used for computation.}

\item{verbose}{Whether to print running process information to the console}
}
\value{
A list of matrices with pathway IDs as the associated list member
names.
}
\description{
Stage 1 Fearture Selection
}
\examples{

library(parallel)
data=MethylData_Test
feature_pathways=Stage1_FeartureSelection(Stage1_FeartureSelection_Method='cor',
                 data=data,cutoff=0,
                 featureAnno=MethylAnno,pathlistDB_sub=GO2ALLEGS_BP,cores=1)

}
\author{
Shunjie Zhang
}
