% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawCurves.R
\name{DrawCurves_MRMC_pairwise}
\alias{DrawCurves_MRMC_pairwise}
\title{Draw the FROC  curves with Colour}
\usage{
DrawCurves_MRMC_pairwise(
  StanS4class,
  modalityID,
  readerID,
  Colour = TRUE,
  DrawFROCcurve = TRUE,
  DrawAFROCcurve = FALSE,
  DrawCFPCTP = TRUE,
  Draw.Flexible.upper_y = TRUE,
  Draw.Flexible.lower_y = TRUE,
  new.imaging.device = TRUE,
  summary = TRUE,
  color_is_changed_by_each_reader = FALSE,
  type = 1
)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

It can be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{modalityID}{This is a vector indicating modalityID whose component is natural namber.}

\item{readerID}{This is a vector indicating readerID whose component is natural namber.}

\item{Colour}{Logical, that is \code{TRUE} or \code{FALSE}. Whether plot  of curves are with dark theme. Default is \code{TRUE} indicating dark theme.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFP and CTP points are to be drawn. CFP: Cumulative false positive per lesion (or image) which is also called False Positive Fraction (FPF). CTP Cumulative True Positive per lesion  which is also called True Positive Fraction (TPF)..}

\item{Draw.Flexible.upper_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the upper bounds of vertical axis are determined automatically.}

\item{Draw.Flexible.lower_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the lower bounds of vertical axis are determined automatically.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{color_is_changed_by_each_reader}{A logical, if \code{TRUE}, then the FROC curves, AFROC curves, and FPF, TPF are colored accordingly by each reader. The aim of FROC analysis is to compare the modality and not reader, so the default value is false, and curves and FPF and TPF are colored by each modalities.}

\item{type}{An integer, for the color of background and etc.}
}
\description{
Draw  \emph{FROC  curves} and \emph{AFROC curves} for user's specified modalities and user's specified readers.
Using this function \emph{\strong{repeatedly}}, we can draw the different reader and modality in a  \emph{\strong{same}} plane simultaneously.
}
\details{
By drawing different modality FROC curves in the same plane, we can compare the modality.
E.g., if some modality FROC curve is \code{upper} then other modality curves,
 then we may say that the upper modality is \code{better} observer performance, i.e., higher AUC.
}
\examples{

\dontrun{
#1) Fit a model to data by the following:



  fit <- fit_Bayesian_FROC(dataList.Chakra.Web, ite = 1111)


#Note that the return value "fit" is an object of an inherited S4 class from stanfit

#2)  Using the above S4 class object, we draw the curves.



 DrawCurves_MRMC_pairwise(fit,
                          modality = 1,
                          reader = 4
                          )



#3) By changing the modality (or reader),
   #we can draw the curves with respect to different  modalities.
   #This shows the comparison of modalites.



 DrawCurves_MRMC_pairwise(fit,
                          modality = 2,
                          reader = 4
                          )

 DrawCurves_MRMC_pairwise(fit,
                          modality = 3,
                          reader = 4
                          )


#4) By repeating in this manner for different modalities or readers,
#    we can draw  AFROC (FROC) curves in a single imaging device.
# Revised 2019 Nov 27



#5) If you want to draw the FROC curves
#for reader ID =1,2,3,4 and modality ID =1,2, then the code is as follows;

DrawCurves_MRMC_pairwise(
                            fit,
                            modalityID = c(1,2,3,4),
                            readerID = c(1,2)
                            )
# Each color of curves corresponds to the modality ID.
# So, even if curves are different readers and same modality, then color is same.














       #   Close the graphic device
           Close_all_graphic_devices()
       } # dottest
}
\author{
Issei Tsunoda
}
