% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit.R
\name{get_samples_from_Posterior_Predictive_distribution}
\alias{get_samples_from_Posterior_Predictive_distribution}
\title{Get Samples from the Predictive Posterior Distribution (PPD).}
\usage{
get_samples_from_Posterior_Predictive_distribution(StanS4class,
  counter.plot.via.schatter.plot = TRUE, new.imaging.device = TRUE,
  upper_x, upper_y, Colour = TRUE, plot.replicated.points = TRUE)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}. This \R object can be passed to the \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{counter.plot.via.schatter.plot}{Logical: \code{TRUE} of \code{FALSE}. Whether counter plot via schatter plot is drawn, Default = \code{TRUE}.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{upper_x}{This is a upper bound for the axis of the horisontal coordinate of FROC curve.}

\item{upper_y}{This is a upper bound for the axis of the vertical coordinate of FROC curve.}

\item{Colour}{Logical: \code{TRUE} of \code{FALSE}.  whether Colour of curves is dark theme or not.}

\item{plot.replicated.points}{TRUE or FALSE. If true, then plot replicated points (hits, false alarms) by the scatter plot. This process will takes a long times. So if user has no time, then \code{FALSE} will help you.}
}
\value{
A list of datalists from the posterior predictive distribution
}
\description{
Get samples from the posterior predictive distribution.
}
\details{
This methods to draw from the PPD is described in Gelman book, Bayesian Data Analysis. The aim of this function is to evaluate the chi square test statistics as a Bayesian sense. According to Gelman book, the chi square test need the samples from the PPD. So, we use this function to accomplish this task.
}
\examples{
 \donttest{



 fit <- fit_Bayesian_FROC(
  ite  = 1111,
   summary = FALSE ,
  dataList = BayesianFROC::dataList.Chakra.1 )





#=======  The first example ======================================================
 TPs.FPs <- get_samples_from_Posterior_Predictive_distribution(fit)


#=======  The Second Example: Short cut    ===========================================
# If user has no time, then  plot.replicated.points=FALSE will help you.
# By setting FALSE, the replicated data from the posterior predictive
# distribution does not draw, and hence the running time of function become shorter.

 TPs.FPs <- get_samples_from_Posterior_Predictive_distribution(fit,
                                   plot.replicated.points =  FALSE)





#      Close the graphic device to avoid errors in R CMD check.

     grDevices::dev.new();plot(stats::runif(100),stats::runif(100))



#================The third example:  From Hand made data to fitting  ==========
#  If user want to use the scatter plots of hits and false alarms from the posterior
#  predictive distribution for the submission, then the color plot is not appropriate.
#  So, by setting the argument Colour = FALSE, the scatter plot become black and white.
#  So, user can use this scatter plot for submission.


 get_samples_from_Posterior_Predictive_distribution(fit,Colour = FALSE)

  g <-get_samples_from_Posterior_Predictive_distribution(fit)

  x <- g$CFP

  y <- g$CTP


 plot(   hexbin::hexbin(unlist(x),unlist(y))   )



#      Close the graphic device to avoid errors in R CMD check.

         Close_all_graphic_devices()
}# dottest


}
