% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_srsc.R
\name{fit_srsc}
\alias{fit_srsc}
\title{Draw an FROC curve and  an AFROC curve using Bayesian approach.
 Build S4 classes by stan in the case of
Single reader and Single modality (srsc)}
\usage{
fit_srsc(dataList, new.imaging.device = TRUE, DrawCurve = T,
  ModifiedPoisson = FALSE, PreciseLogLikelihood = FALSE,
  Drawcol = TRUE, summary = TRUE, DrawFROCcurve = TRUE,
  DrawAFROCcurve = FALSE, DrawCFPCTP = TRUE,
  mesh.for.drawing.curve = 10000, make.csv.file.to.draw.curve = FALSE,
  cha = 4, ite = 3000, dig = 5, war = floor(ite/5), see = 1234)
}
\arguments{
\item{dataList}{it should include  \code{f, h, NL, NI, C}.
The detail of these dataset, please see the endowed datasets.
Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level should not included  your data. So, to confirm
your false positives and hits are correctly correspondence
to confidence levels,
you should confirm the orders by the function}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{DrawCurve}{This is a dichotomous, i.e., TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}. The reason why the author make this variable \code{DrawCurve} is that it take long time to draw curves, and thus default value is \code{FALSE}.}

\item{ModifiedPoisson}{This is dichotomous, that is TRUE or FALSE. If
ModifiedPoisson = TRUE, then Poisson rate of false alarm are per lesion,
and if ModifiedPoisson = FALSE, then Poisson rate of false alarm are per image.
To know detail, user read the author's paper in which I explained per image and per lesion.}

\item{PreciseLogLikelihood}{If \code{PreciseLogLikelihood} = TRUE, then Stan calculates the precise log likelihood.

If \code{PreciseLogLikelihood} = FALSE, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.}

\item{Drawcol}{Logical: \code{TRUE} of \code{FALSE}. Whether the (A)FROC curve is to be drawn  by using color of dark theme. The default value is a \code{TRUE}.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; whether to list verbose data of estimates when printing. If TRUE then verbose summary and additional estimates are printed in the R console. If FALSE, the output is minimal. I regret, this variable name should be verbose.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFPCTP points are  to be drawn.}

\item{mesh.for.drawing.curve}{An integer indicating number of dots drawing the curves, default =10000.}

\item{make.csv.file.to.draw.curve}{Logical: \code{TRUE} of \code{FALSE}. Whether  to create a csv file. If TRUE then csv file is created in your desktop to draw an FROC curve and cumulative hits and false alarms by scatter plot. Default is FALSE since it took times to create csv files.}

\item{cha}{An argument of \code{rstan::stan}, which means the number of chains generated by Hamiltonian Monte Carlo method,
and, default = 4.}

\item{ite}{An argument of \code{rstan::stan}, which means the number of samples generated by Hamiltonian Monte Carlo method,
and, default = 3000. If your model could not converge, then raise this number.}

\item{dig}{An argument of \code{rstan::stan}, which means the Significant digits, used in stan Cancellation. default = 3,}

\item{war}{An argument of \code{rstan::stan}, which means the Burn in period, default = 1000,}

\item{see}{An argument of \code{rstan::stan}, which means a seed used in stan,


default = 1234.
 If your model could not converge,
then change this number.}
}
\value{
An S4 class, created by  \code{rstan::stan}. Using this S4 class , you can go ahead to the next step,
that is, drawing the FROC curve and alternative FROC (AFROC) curves.
}
\description{
Build the S4 class by stan with your single reader
and single modality data \code{dataList}.

The model is the author's Bayesian model introduced the author's paper.

Before running the function \code{stan_srsc}, you should confirm
that your dataset is correctly formulated by the function \code{viewdataSRSC()}.
}
\examples{
\donttest{
#First, we prepare the data endowed with this package.

        dat  <- get(data("dataList.Chakra.1"))




#Second, we run the stan funtion
#with data named "dat"  and the author's Bayesian model.


           fit <-  fit_srsc(dat)






#Now, we get the stan's out put S4 class named "fit".

#Using the return value "fit",

#we can use the functions in the "rstan" package,
# To do so, we have to change the class from the inherited class to
# the class of the stanfit, as follows;


        fit <- as(fit, "stanfit")

#   e.g.,

          rstan::stan_trace(fit)
          rstan::stan_hist(fit)
          rstan::stan_rhat(fit)

}#donttest
}
