% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-HybridPop.R
\docType{class}
\name{HybridPop-class}
\alias{HybridPop-class}
\alias{[,HybridPop-method}
\alias{c,HybridPop-method}
\title{Hybrid population}
\usage{
\S4method{[}{HybridPop}(x, i)

\S4method{c}{HybridPop}(x, ...)
}
\arguments{
\item{x}{a 'HybridPop'}

\item{i}{index of individuals}

\item{...}{additional 'HybridPop' objects}
}
\description{
A lightweight version of \code{\link{Pop-class}} for hybrid lines.
Memory is saved by not storing genotypic data.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: Extract HybridPop using index or id

\item \code{c}: Combine multiple HybridPops
}}

\section{Slots}{

\describe{
\item{\code{nInd}}{number of individuals}

\item{\code{id}}{an individual's identifier}

\item{\code{mother}}{the identifier of the individual's mother}

\item{\code{father}}{the identifier of the individual's father}

\item{\code{nTraits}}{number of traits}

\item{\code{gv}}{matrix of genetic values. When using GxE traits,
gv reflects gv when p=0.5. Dimensions are nInd by nTraits.}

\item{\code{pheno}}{matrix of phenotypic values. Dimensions are
nInd by nTraits.}

\item{\code{gxe}}{list containing GxE slopes for GxE traits}
}}

