% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\name{newPop}
\alias{newPop}
\title{Create new Population}
\usage{
newPop(
  rawPop,
  mother = NULL,
  father = NULL,
  origM = NULL,
  origF = NULL,
  isDH = FALSE,
  simParam = NULL
)
}
\arguments{
\item{rawPop}{an object of \code{\link{MapPop-class}} or 
\code{\link{RawPop-class}}}

\item{mother}{optional id for mothers. Must match 
id in pedigree if using track pedigree.}

\item{father}{optional id for fathers. Must match 
id in pedigree if using track pedigree.}

\item{origM}{optional alternative id for mothers}

\item{origF}{optional alternative id for fathers}

\item{isDH}{optional value indicating if the individuals 
are doubled haploids and/or inbred founders}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Creates a new \code{\link{Pop-class}} from an object of 
\code{\link{MapPop-class}} or \code{\link{RawPop-class}}. 
The function is intended for creating initial populations from 
'FOUNDERPOP' created by \code{\link{runMacs}}.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

}
