% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plot_dissimilarity_matrix}
\alias{plot_dissimilarity_matrix}
\title{A heatmap plot of the dissimilarity matrix of two multiple sequence alignments}
\usage{
plot_dissimilarity_matrix(x, display = TRUE)
}
\arguments{
\item{x}{an object of type "pairwise alignment comparison" (typically the summary file generated by compare_alignments)}

\item{display}{display this plot (default = TRUE)}
}
\description{
A heatmap plot of the dissimilarity matrix of two multiple sequence alignments
}
\note{
This function displays the dissimilarity categories for all characters in the reference alignment. This gives a representation of which columns are well agreed upon by the MSAs, and which sequence regions of the reference alignment are split, merged, or shifted.
}
\examples{
data(reference_alignment)
data(comparison_alignment)
PAC <- compare_alignments(reference_alignment,comparison_alignment)
plot_dissimilarity_matrix(PAC)

}

