test_that("hop-by-hop headers removed from Rook requests", {
  rook_req <-
    list(
      HTTP_CONNECTION = "keep-alive",
      HTTP_UPGRADE_INSECURE_REQUESTS = "1",
      HTTP_ACCEPT = "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8",
      HTTP_ACCEPT_LANGUAGE = "en-US,en;q=0.9",
      QUERY_STRING = "",
      httpuv.version = structure(list(c(1L, 4L, 5L, 9000L)), class = c(
        "package_version",
        "numeric_version"
      )),
      SERVER_NAME = "127.0.0.1",
      SCRIPT_NAME = "",
      SERVER_PORT = "8600",
      REMOTE_PORT = "37514",
      PATH_INFO = "/",
      rook.version = "1.1-0",
      REMOTE_ADDR = "127.0.0.1",
      HEADERS = c(
        accept = "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8",
        `accept-encoding` = "gzip, deflate, br",
        `accept-language` = "en-US,en;q=0.9",
        connection = "keep-alive",
        host = "127.0.0.1:8600",
        `upgrade-insecure-requests` = "1",
        `user-agent` = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Ubuntu Chromium/68.0.3440.75 Chrome/68.0.3440.75 Safari/537.36"
      ),
      rook.url_scheme = "http",
      HTTP_ACCEPT_ENCODING = "gzip, deflate, br",
      REQUEST_METHOD = "GET",
      HTTP_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Ubuntu Chromium/68.0.3440.75 Chrome/68.0.3440.75 Safari/537.36",
      HTTP_HOST = "127.0.0.1:8600"
    )
  to_remove <- headers_to_remove(rook_req$HTTP_CONNECTION)
  curl_req <- req_rook_to_curl(rook_req, "example.com", 80)
  expect_length(base::intersect(to_remove, names(curl_req)), 0)
})

test_that("hop-by-hop headers removed from httr responses", {
  httr_resp <-
    list(
      url = "http://localhost:3838/01_hello/__sockjs__/n=aEreraSWVKPtvbROET/t=85b97b86caa352d0f9cea31b16ad9a17/w=a281af4b76221b50ea014d90916a4ec99d2ff0d55305dd74/s=0/info",
      status_code = 200L,
      headers = as.raw(
        c(
          0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x31, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4f, 0x4b, 0x0d, 0x0a, 0x58, 0x2d, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x65, 0x64, 0x2d,
          0x42, 0x79, 0x3a, 0x20, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x0d, 0x0a, 0x53, 0x65, 0x74, 0x2d, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x3a, 0x20, 0x53, 0x53,
          0x50, 0x2d, 0x58, 0x53, 0x52, 0x46, 0x3d, 0x6e, 0x47, 0x41, 0x44, 0x4b, 0x49, 0x66, 0x6a, 0x2d, 0x77, 0x76, 0x79, 0x6e, 0x66, 0x49, 0x36, 0x77, 0x52, 0x31, 0x74,
          0x79, 0x50, 0x77, 0x4d, 0x69, 0x4b, 0x6a, 0x4c, 0x44, 0x4f, 0x62, 0x77, 0x50, 0x59, 0x54, 0x38, 0x3b, 0x20, 0x50, 0x61, 0x74, 0x68, 0x3d, 0x2f, 0x0d, 0x0a, 0x41,
          0x63, 0x63, 0x65, 0x73, 0x73, 0x2d, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2d, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x2d, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x3a,
          0x20, 0x2a, 0x0d, 0x0a, 0x56, 0x61, 0x72, 0x79, 0x3a, 0x20, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x0d, 0x0a, 0x43, 0x61, 0x63, 0x68, 0x65, 0x2d, 0x43, 0x6f, 0x6e,
          0x74, 0x72, 0x6f, 0x6c, 0x3a, 0x20, 0x6e, 0x6f, 0x2d, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c, 0x20, 0x6e, 0x6f, 0x2d, 0x63, 0x61, 0x63, 0x68, 0x65, 0x2c, 0x20, 0x6e,
          0x6f, 0x2d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x2d, 0x72, 0x65, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
          0x65, 0x2c, 0x20, 0x6d, 0x61, 0x78, 0x2d, 0x61, 0x67, 0x65, 0x3d, 0x30, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x3a,
          0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d,
          0x55, 0x54, 0x46, 0x2d, 0x38, 0x0d, 0x0a, 0x44, 0x61, 0x74, 0x65, 0x3a, 0x20, 0x4d, 0x6f, 0x6e, 0x2c, 0x20, 0x32, 0x30, 0x20, 0x41, 0x75, 0x67, 0x20, 0x32, 0x30,
          0x31, 0x38, 0x20, 0x32, 0x32, 0x3a, 0x34, 0x38, 0x3a, 0x35, 0x37, 0x20, 0x47, 0x4d, 0x54, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
          0x3a, 0x20, 0x6b, 0x65, 0x65, 0x70, 0x2d, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x0d, 0x0a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2d, 0x45, 0x6e, 0x63, 0x6f,
          0x64, 0x69, 0x6e, 0x67, 0x3a, 0x20, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x65, 0x64, 0x0d, 0x0a, 0x0d, 0x0a
        )
      ),
      modified = structure(NA_integer_, class = c(
        "POSIXct",
        "POSIXt"
      )),
      times = c(
        redirect = 0,
        namelookup = 4.4e-05,
        connect = 4.6e-05,
        pretransfer = 0.000126,
        starttransfer = 0.002685,
        total = 0.002759
      ),
      content = as.raw(
        c(
          0x7b, 0x22, 0x77, 0x65, 0x62, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x3a, 0x74, 0x72, 0x75, 0x65, 0x2c, 0x22, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x73, 0x22,
          0x3a, 0x5b, 0x22, 0x2a, 0x3a, 0x2a, 0x22, 0x5d, 0x2c, 0x22, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x6e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x22, 0x3a, 0x66, 0x61,
          0x6c, 0x73, 0x65, 0x2c, 0x22, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x79, 0x22, 0x3a, 0x33, 0x33, 0x36, 0x35, 0x34, 0x38, 0x30, 0x32, 0x35, 0x31, 0x7d
        )
      )
    )
  headers <- curl::parse_headers_list(httr_resp$headers)
  to_remove <- headers_to_remove(headers$connection)
  rook_resp <- resp_httr_to_rook(httr_resp)
  expect_length(base::intersect(to_remove, names(rook_resp$headers)), 0)
})
