% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_window.R
\name{UpdateSimulationWindow}
\alias{UpdateSimulationWindow}
\title{Update the simulation window in a SpatSimObj}
\usage{
UpdateSimulationWindow(sim_object, window = NULL)
}
\arguments{
\item{sim_object}{A \code{SpatSimObj} object}

\item{window}{A new \code{owin} object representing the updated simulation window}
}
\value{
The updated \code{SpatSimObj} object
}
\description{
This function updates the simulation window of a \code{SpatSimObj} by replacing
the existing window with a new one.
}
\details{
The \code{UpdateSimulationWindow()} function checks that the input \code{sim_object} is of class
'SpatSimObj', that the input \code{window} is not null and is of class 'owin'.
If these checks pass, the function updates the simulation window in the input \code{sim_object} and
returns the updated \code{SpatSimObj} object.
}
\examples{
# Create a simulation object
sim_obj <- CreateSimulationObject()

# Update the simulation window
new_window <- spatstat.geom::owin(c(0, 5), c(0, 5))
updated_sim_obj <- UpdateSimulationWindow(sim_obj, window = new_window)

}
\seealso{
\code{\link{CreateSimulationObject}}
}
