% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr.R
\name{ocv_qr_detect}
\alias{ocv_qr_detect}
\alias{qr_scanner}
\title{Detect and Decode a QR code}
\usage{
ocv_qr_detect(image, draw = FALSE, decoder = c("wechat", "quirc"))

qr_scanner(draw = FALSE, decoder = c("wechat", "quirc"))
}
\arguments{
\item{image}{an ocv image object created from e.g. \code{\link[=ocv_read]{ocv_read()}}}

\item{draw}{if TRUE, the function returns an annotated image showing
the position and value of the QR code.}

\item{decoder}{which decoder implementation to use, see details.}
}
\value{
if a QR code is detected, this returns either the text value of the QR,
or if \code{draw} it returns the annotated image, with the value as an attribute.
Returns NULL if no QR was found in the image.
}
\description{
Detect and decode a QR code from an image or camera. By default it returns
the text value from the QR code if detected, or NULL if no QR was found. If
\code{draw = TRUE} then it returns an annotated image with the position and
value of the QR drawn into the image, and qr text value as an attribute.
The \code{qr_scanner} function opens the camera device (if available on your
computer) and repeats \link{ocv_qr_detect} until it a QR is detected.
}
\details{
OpenCV has two separate QR decoders. The 'wechat' decoder was added in
libopencv 4.5.2 and generally has better performance and fault-tolerance.
The old 'quirc' decoder is available on some older versions of libopencv as
a plug-in, but many Linux distros did not include it. If you get an error
\emph{Library QUIRC is not linked. No decoding is performed.} this sadly means
your Linux distribution is too old and does not support QR decoding.
}
\examples{
png("test.png")
plot(qrcode::qr_code("This is a test"))
dev.off()
ocv_qr_detect(ocv_read('test.png'))
unlink("test.png")
}
