% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrefmodp.R
\name{rref_p}
\alias{rref_p}
\title{Find the RREF of a matrix mod p}
\usage{
rref_p(A, p)
}
\arguments{
\item{A}{A matrix}

\item{p}{A prime integer}
}
\value{
A matrix of the same size as \code{A} which is the unique reduced-row echelon form of \code{A}.
}
\description{
\code{rref_p()} calculates the unique reduced-row echelon form of a matrix with entries in the finite field \eqn{F_p}.
}
\examples{
B <- matrix(c(3, 4, 1, 3, 2, 0), 2, 3)
rref_p(B, 5)
C <- matrix(c(0, 2, 0, 0, 0, 2, 0, 1, 1), 3, 3)
rref_p(C, 3)
}
