% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_primers_trim_reads.R
\name{cut_trim}
\alias{cut_trim}
\title{Main command to trim primers using 'Cutadapt' and core 'DADA2' functions}
\usage{
cut_trim(analysis_setup, cutadapt_path, overwrite_existing = FALSE)
}
\arguments{
\item{analysis_setup}{An object containing directory paths and data tables,
produced by the \code{prepare_reads} function}

\item{cutadapt_path}{Path to the 'Cutadapt' program.}

\item{overwrite_existing}{Logical, indicating whether to remove or overwrite
existing files and directories from previous runs. Default is \code{FALSE}.}
}
\value{
Trimmed reads, primer counts, quality plots, and ASV matrix.
}
\description{
Main command to trim primers using 'Cutadapt' and core 'DADA2' functions
}
\details{
If samples are comprised of two different metabarcodes (like ITS1 and rps10), reads will also be demultiplexed prior to 'DADA2'-specific read trimming steps.
}
\examples{
\donttest{
# Remove remaining primers from raw reads, demultiplex pooled barcoded samples,
# and then trim reads based on specific 'DADA2' parameters
analysis_setup <- prepare_reads(
  data_directory = system.file("extdata", package = "demulticoder"),
  output_directory = tempdir(),
  overwrite_existing = TRUE
)
cut_trim(
analysis_setup,
cutadapt_path="/usr/bin/cutadapt",
overwrite_existing = TRUE
)
}
}
