% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{sp_add_arrows}
\alias{sp_add_arrows}
\title{Add Arrows to a SveltePlot Chart}
\usage{
sp_add_arrows(
  sp,
  x_start,
  x_end,
  y_start,
  y_end,
  arrow_head_type = NULL,
  size = NULL,
  color = "black",
  curvature = 1e-05,
  direction = "upward",
  arrow_head = NULL
)
}
\arguments{
\item{sp}{A SveltePlot htmlwidget object to which arrows will be added.}

\item{x_start}{Numeric vector specifying the starting x-coordinates of the arrows.}

\item{x_end}{Numeric vector specifying the ending x-coordinates of the arrows.}

\item{y_start}{Numeric vector specifying the starting y-coordinates of the arrows.}

\item{y_end}{Numeric vector specifying the ending y-coordinates of the arrows.}

\item{arrow_head_type}{Character vector specifying the type of arrow head. Can be customized to suit different visualization needs.}

\item{size}{Numeric vector specifying the size of the arrows.}

\item{color}{Character vector specifying the color of the arrows. Default is "black".}

\item{curvature}{Numeric vector specifying the curvature of the arrows. This is useful for creating curved arrows that can more naturally point between two points on the chart.}

\item{direction}{Character vector specifying the direction of the arrow. Valid options are "upward" or "downward". Default is "upward".}

\item{arrow_head}{Also not sure what it does.}
}
\value{
An object of class \code{htmlwidget} representing the plot with arrows added.
}
\description{
Adds arrows to a SveltePlot chart to illustrate directions, trends, or to point out specific data points.
This function enhances the chart's ability to convey insights to the viewer.
}
\examples{
library(SveltePlots)
data("purchases")

sp(
  data = purchases, type = "line",
  mapping = spaes(x = date, y = revenue_roll, group = age),
  colors = c("red", "green", "blue"),
  combine_same_groups = TRUE
) |>
  sp_add_series(
    data = purchases,
    mapping = spaes(x = date, y = revenue, group = age),
    type = "points",
    alpha = 0.4,
    tooltip = FALSE,
    include_legend = FALSE
  ) |>
  sp_add_series(
    data = purchases[purchases$revenue == max(purchases$revenue), ],
    mapping = spaes(x = date, y = revenue, group = age),
    type = "points",
    size = 5,
    tooltip = FALSE
  ) |>
  sp_add_segments(
    x_start = "2000-01-12", x_end = "2000-01-17",
    y_start = "auto", y_end = "auto",
    type = "rect",
    opacity = 0.2,
    background_color = "black",
    text_color = "white",
    show_legend = TRUE,
    legend_text = "Highest Revenue Day",
    tooltip = "Revenue: <strong>$13179</strong>"
  ) |>
  sp_add_arrows(
    x_start = c("2000-03-01", "2000-03-01"), x_end = c("2000-01-15", "2000-01-15"),
    y_start = c(8000, 12000), y_end = c(10000, 13000),
    arrow_head = c(0, 0),
    size = c(200, 200),
    curvature = c(0.2, 0.4),
    direction = c("downward", "downward"),
    color = c("black", "black"),
    arrow_head_type = c("triangle", "triangle")
  ) |>
  sp_add_text(
    x = c("2000-02-01", "2000-02-20"),
    y = c(12500, 8500),
    text = c(
      "This was the highest revenue day",
      "Window of Some Event Happening"
    )
  )
}
