% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSize.R
\name{derive_allocation_rate}
\alias{derive_allocation_rate}
\title{Derive and Validate Treatment Allocation Rate (TAR)}
\usage{
derive_allocation_rate(TAR = NULL, arm_names, verbose = FALSE)
}
\arguments{
\item{TAR}{Optional numeric vector specifying the allocation rate for each treatment arm. If missing, a default
equal allocation rate is assigned.}

\item{arm_names}{Character vector specifying the names of the treatment arms. Used to name the elements of \code{TAR}.}

\item{verbose}{Logical, if \code{TRUE}, displays messages about the status of \code{TAR} derivation or assignment.}
}
\value{
A named list representing the treatment allocation rate for each arm.
}
\description{
This function validates and adjusts the treatment allocation rate (\code{TAR}) to ensure it is correctly specified
for the given number of treatment arms (\code{n_arms}). If \code{TAR} is missing or NULL, it is assigned a default
vector of ones, ensuring equal allocation across all arms. The function also handles cases where \code{TAR}
is shorter than \code{n_arms}, contains NA values, or has invalid values.
}
\author{
Thomas Debray \email{tdebray@fromdatatowisdom.com}
}
\keyword{internal}
