% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{plot.LocalControlCR}
\alias{plot.LocalControlCR}
\title{Plot cumulative incidence functions (CIFs) from Local Control.}
\usage{
\method{plot}{LocalControlCR}(
  x,
  ...,
  rad2plot,
  xlim,
  ylim = c(0, 1),
  col1 = "blue",
  col0 = "red",
  xlab = "Time",
  ylab = "Cumulative incidence",
  legendLocation = "topleft",
  main = "",
  group1 = "Treatment 1",
  group0 = "Treatment 0"
)
}
\arguments{
\item{x}{Return object from LocalControl with outcomeType = "survival".}

\item{...}{
  Arguments passed on to \code{\link[graphics:plot.default]{graphics::plot.default}}
  \describe{
    \item{\code{type}}{1-character string giving the type of plot desired.  The
    following values are possible, for details, see \code{\link[graphics]{plot}}:
    \code{"p"} for points, \code{"l"} for lines,
    \code{"b"} for both points and lines,
    \code{"c"} for empty points joined by lines,
    \code{"o"} for overplotted points and lines,
    \code{"s"} and \code{"S"} for stair steps and
    \code{"h"} for histogram-like vertical lines.  Finally,
    \code{"n"} does not produce any points or lines.}
    \item{\code{log}}{a character string which contains \code{"x"} if the x axis
    is to be logarithmic, \code{"y"} if the y axis is to be logarithmic
    and \code{"xy"} or \code{"yx"} if both axes are to be logarithmic.}
    \item{\code{sub}}{a subtitle for the plot.}
    \item{\code{ann}}{a logical value indicating whether the default annotation
    (title and x and y axis labels) should appear on the plot.}
    \item{\code{axes}}{a logical value indicating whether both axes should be drawn on
    the plot.  Use \link[graphics]{graphical parameter} \code{"xaxt"} or \code{"yaxt"}
    to suppress just one of the axes.}
    \item{\code{frame.plot}}{a logical indicating whether a box should be drawn
    around the plot.}
    \item{\code{panel.first}}{an \sQuote{expression} to be evaluated after the
    plot axes are set up but before any plotting takes place.  This can
    be useful for drawing background grids or scatterplot smooths.  Note
    that this works by lazy evaluation: passing this argument from other
    \code{plot} methods may well not work since it may be evaluated too
    early.}
    \item{\code{panel.last}}{an expression to be evaluated after plotting has
    taken place but before the axes, title and box are added.  See the
    comments about \code{panel.first}.}
    \item{\code{asp}}{the \eqn{y/x} aspect ratio, see \code{\link[graphics]{plot.window}}.}
    \item{\code{xgap.axis,ygap.axis}}{the \eqn{x/y} axis gap factors, passed as
    \code{gap.axis} to the two \code{\link[graphics]{axis}()} calls (when
    \code{axes} is true, as per default).}
  }}

\item{rad2plot}{The index or name ("rad_#") of the radius to plot. By default, the radius with pct_informative closest to
0.8 will be selected.}

\item{xlim}{The x axis bounds. Defaults to c(0, max(lccrResults$Failtimes)).}

\item{ylim}{The y axis bounds. Defaults to c(0,1).}

\item{col1}{The plot color for group 1.}

\item{col0}{The plot color for group 0.}

\item{xlab}{The x axis label. Defaults to "Time".}

\item{ylab}{The y axis label. Defaults to "Cumulative incidence".}

\item{legendLocation}{The location to place the legend. Default "topleft".}

\item{main}{The main plot title. Default is empty.}

\item{group1}{The name of the primary group (Treatment 1).}

\item{group0}{The name of the secondary group (Treatment 0).}
}
\description{
Given the results from LocalControl with outcomeType = "survival",
  plot a corrected and uncorrected cumulative incidence function (CIF) for both groups.
}
\examples{
data("cardSim")
results = LocalControl(data = cardSim,
                       outcomeType = "survival",
                       outcomeColName = "status",
                       timeColName = "time",
                       treatmentColName = "drug",
                       treatmentCode = 1,
                       clusterVars = c("age", "bmi"))
plot(results)

}
\references{
\itemize{
   \item Lauve NR, Nelson SJ, Young SS, Obenchain RL, Lambert CG. LocalControl: An R Package for Comparative Safety and Effectiveness Research. Journal of Statistical Software. 2020. p. 1-32. Available from: http://dx.doi.org/10.18637/jss.v096.i04
}
}
