% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebase_years.R
\name{ebase_years}
\alias{ebase_years}
\title{Estuarine Bayesian Single-station Estimation method for ecosystem metabolism for long time series}
\usage{
ebase_years(
  dat,
  Z,
  interval,
  ndays = 1,
  aprior = c(4, 2),
  rprior = c(300, 150),
  bprior = c(0.251, 0.125),
  bmax = 0.502,
  nogas = FALSE,
  doave = TRUE,
  maxinterp = 43200/interval,
  n.iter = 10000,
  update.chains = TRUE,
  n.burnin = n.iter * 0.5,
  n.chains = 3,
  n.thin = 10,
  model_file = NULL,
  ncores = NULL,
  quiet = TRUE,
  maxtry = 5
)
}
\arguments{
\item{dat}{input data frame}

\item{Z}{numeric as single value for water column depth (m) or vector equal in length to number of rows in \code{dat}}

\item{interval}{timestep interval in seconds}

\item{ndays}{numeric for number of days in \code{dat} for optimizing the metabolic equation, see details}

\item{aprior}{numeric vector of length two indicating the mean and standard deviation for the prior distribution of the \emph{a} parameter, see details}

\item{rprior}{numeric vector of length two indicating the mean and standard deviation for the prior distribution of the \emph{R} parameter, see details}

\item{bprior}{numeric vector of length two indicating the mean and standard deviation for the prior distribution of the \emph{b} parameter, see details}

\item{bmax}{numeric value for the upper limit on the prior distribution for \code{bprior}, set as twice the default value of the mean}

\item{nogas}{logical indicating if gas exchange is not included in the metabolic model, see details}

\item{doave}{logical indicating if the average dissolved oxygen concentration is used as the starting value for the estimation (default), otherwise the first observation will be used if \code{FALSE}, see details}

\item{maxinterp}{numeric value for minimum number of continuous observations that must not be interpolated within a group defined by \code{ndays} to assign as \code{NA} in output, see details}

\item{n.iter}{number of MCMC iterations, passed to \code{\link[R2jags]{jags}}}

\item{update.chains}{logical to run \code{\link{metab_update}} if chains do not converge}

\item{n.burnin}{number of MCMC chains to delete, passed to \code{\link[R2jags]{jags}}}

\item{n.chains}{number of MCMC chains to run, passed to \code{\link[R2jags]{jags}}}

\item{n.thin}{number of nth iterations to save for each chain, passed to \code{\link[R2jags]{jags}}}

\item{model_file}{\code{NULL} to use the model file included with the package or a path to a model text file can be used}

\item{ncores}{numeric for number of cores to use for parallel processing, use \code{NULL} to suppress}

\item{quiet}{logical to suppress progress messages to the console}

\item{maxtry}{numeric for maximum number of times to retry the model if it fails}
}
\value{
Output identical to that returned by \code{\link{ebase}}, where the results for each year are appended to the data frame as the function progresses through the years. Note that the \code{grp} column that specifies the optimization period defined by \code{ndays} is unique to each year, e.g., values will be repeated across years.
}
\description{
Estuarine Bayesian Single-station Estimation method for ecosystem metabolism for long time series
}
\details{
\code{\link{ebase}} is run for each year in the supplied data. This facilitates running \code{\link{ebase}} on long time series by running the model sequentially on each year of data, with progress messages printed to the console if \code{quiet = FALSE}. The model run for each year will restart if it fails, up to \code{maxtry} times, after which processing continues with the next year.  The model is run in parallel using the number of cores used set by \code{ncores}. If \code{ncores = NULL}, sequential processing is used.  All other arguments are passed to \code{\link{ebase}}.

Similar results can be obtained by running \code{\link{ebase}} on the entire data set, but this function is useful for long time series where the model may fail for some years, e.g., when weather data may be missing for some years.
}
\examples{
# get one day of data
dat <- exdat[as.Date(exdat$DateTimeStamp, tz = 'America/Jamaica') == as.Date('2012-06-01'), ]

# run ebase, use more chains and iterations for a better fit, update.chains as T
ebase_years(dat, Z = 1.85, interval = 900, n.chains = 2, n.iter = 50, 
 update.chains = FALSE)
}
