## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(envsetup)

# Create temporary directory structure
dir <- fs::file_temp()
dir.create(dir)
config_path <- file.path(dir, "_envsetup.yml")

# Write configuration with multiple data paths
file_conn <- file(config_path)
writeLines(
  paste0(
"default:
  paths:
    data: !expr list(DEV = '", dir,"/demo/DEV/username/project1/data', PROD = '", dir, "/demo/PROD/project1/data')
    output: '", dir, "/demo/DEV/username/project1/output'
    programs: '", dir, "/demo/DEV/username/project1/programs'
    envsetup_environ: !expr Sys.setenv(ENVSETUP_ENVIRON = 'DEV'); 'DEV'"
 ), file_conn)
close(file_conn)

# Load and apply configuration
envsetup_config <- config::get(file = config_path)
rprofile(envsetup_config)

## ----echo = TRUE--------------------------------------------------------------
# See all configured objects
ls(envsetup_environment)

# Data is now a named list with multiple locations
get_path(data)
get_path(output)
get_path(programs)
get_path(envsetup_environ)

## -----------------------------------------------------------------------------
# Create the directory structure
dir.create(file.path(dir, "/demo/DEV/username/project1/data"), recursive = TRUE)
dir.create(file.path(dir, "/demo/PROD/project1/data"), recursive = TRUE)

# Add data only to PROD location
saveRDS(mtcars, file.path(dir, "/demo/PROD/project1/data/mtcars.RDS"))

# read_path() finds the file in PROD
read_path(data, "mtcars.RDS")

## -----------------------------------------------------------------------------
# Add the same data to DEV location
saveRDS(mtcars, file.path(dir, "/demo/DEV/username/project1/data/mtcars.RDS"))

# Now read_path() returns DEV location (first in search order)
read_path(data, "mtcars.RDS")

## -----------------------------------------------------------------------------
# Update config to include prod environment
file_conn <- file(config_path)
writeLines(
  paste0(
"default:
  paths:
    data: !expr list(DEV = '",dir,"/demo/DEV/username/project1/data', PROD = '",dir,"/demo/PROD/project1/data')
    output: '",dir,"/demo/DEV/username/project1/output'
    programs: '",dir,"/demo/DEV/username/project1/programs'
    envsetup_environ: !expr Sys.setenv(ENVSETUP_ENVIRON = 'DEV'); 'DEV'

prod:
  paths:
    envsetup_environ: !expr Sys.setenv(ENVSETUP_ENVIRON = 'PROD'); 'PROD'"
  ), file_conn)
close(file_conn)

# Load production configuration
envsetup_config <- config::get(file = config_path, config = "prod")
rprofile(envsetup_config)

# Check the environment setting
get_path(envsetup_environ)

## -----------------------------------------------------------------------------
# In production, read_path() returns PROD location even though DEV exists
read_path(data, "mtcars.RDS")

## ----eval=FALSE---------------------------------------------------------------
# # Instead of hardcoding paths:
# # my_data <- readRDS("/some/hardcoded/path/mtcars.RDS")
# 
# # Use dynamic path resolution:
# data_path <- read_path(data, "mtcars.RDS")
# my_data <- readRDS(data_path)
# 
# # This works regardless of environment or data location!

## ----echo = FALSE-------------------------------------------------------------
# Clean up
unlink(dir, recursive=TRUE)

